// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Containers.ContainerRegistry
{
    internal partial class FsLayer
    {
        internal static FsLayer DeserializeFsLayer(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string blobSum = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("blobSum"u8))
                {
                    blobSum = property.Value.GetString();
                    continue;
                }
            }
            return new FsLayer(blobSum);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static FsLayer FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeFsLayer(document.RootElement);
        }
    }
}
