// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Containers.ContainerRegistry
{
    /// <summary> Properties of this repository. </summary>
    public partial class ContainerRepositoryProperties
    {
        /// <summary> Initializes a new instance of <see cref="ContainerRepositoryProperties"/>. </summary>
        /// <param name="registryLoginServer"> Registry login server name. This is likely to be similar to {registry-name}.azurecr.io. </param>
        /// <param name="name"> Image name. </param>
        /// <param name="createdOn"> Image created time. </param>
        /// <param name="lastUpdatedOn"> Image last update time. </param>
        /// <param name="manifestCount"> Number of the manifests. </param>
        /// <param name="tagCount"> Number of the tags. </param>
        internal ContainerRepositoryProperties(string registryLoginServer, string name, DateTimeOffset createdOn, DateTimeOffset lastUpdatedOn, int manifestCount, int tagCount)
        {
            RegistryLoginServer = registryLoginServer;
            Name = name;
            CreatedOn = createdOn;
            LastUpdatedOn = lastUpdatedOn;
            ManifestCount = manifestCount;
            TagCount = tagCount;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRepositoryProperties"/>. </summary>
        /// <param name="registryLoginServer"> Registry login server name. This is likely to be similar to {registry-name}.azurecr.io. </param>
        /// <param name="name"> Image name. </param>
        /// <param name="createdOn"> Image created time. </param>
        /// <param name="lastUpdatedOn"> Image last update time. </param>
        /// <param name="manifestCount"> Number of the manifests. </param>
        /// <param name="tagCount"> Number of the tags. </param>
        /// <param name="canDelete"> Delete enabled. </param>
        /// <param name="canWrite"> Write enabled. </param>
        /// <param name="canList"> List enabled. </param>
        /// <param name="canRead"> Read enabled. </param>
        internal ContainerRepositoryProperties(string registryLoginServer, string name, DateTimeOffset createdOn, DateTimeOffset lastUpdatedOn, int manifestCount, int tagCount, bool? canDelete, bool? canWrite, bool? canList, bool? canRead)
        {
            RegistryLoginServer = registryLoginServer;
            Name = name;
            CreatedOn = createdOn;
            LastUpdatedOn = lastUpdatedOn;
            ManifestCount = manifestCount;
            TagCount = tagCount;
            CanDelete = canDelete;
            CanWrite = canWrite;
            CanList = canList;
            CanRead = canRead;
        }

        /// <summary> Registry login server name. This is likely to be similar to {registry-name}.azurecr.io. </summary>
        public string RegistryLoginServer { get; }
        /// <summary> Image name. </summary>
        public string Name { get; }
        /// <summary> Image created time. </summary>
        public DateTimeOffset CreatedOn { get; }
        /// <summary> Image last update time. </summary>
        public DateTimeOffset LastUpdatedOn { get; }
        /// <summary> Number of the manifests. </summary>
        public int ManifestCount { get; }
        /// <summary> Number of the tags. </summary>
        public int TagCount { get; }
    }
}
