// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Containers.ContainerRegistry
{
    internal static partial class ArtifactTagOrderExtensions
    {
        public static string ToSerialString(this ArtifactTagOrder value) => value switch
        {
            ArtifactTagOrder.None => "none",
            ArtifactTagOrder.LastUpdatedOnDescending => "timedesc",
            ArtifactTagOrder.LastUpdatedOnAscending => "timeasc",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ArtifactTagOrder value.")
        };

        public static ArtifactTagOrder ToArtifactTagOrder(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "none")) return ArtifactTagOrder.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "timedesc")) return ArtifactTagOrder.LastUpdatedOnDescending;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "timeasc")) return ArtifactTagOrder.LastUpdatedOnAscending;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ArtifactTagOrder value.");
        }
    }
}
