// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Containers.ContainerRegistry
{
    internal static partial class ArtifactManifestOrderExtensions
    {
        public static string ToSerialString(this ArtifactManifestOrder value) => value switch
        {
            ArtifactManifestOrder.None => "none",
            ArtifactManifestOrder.LastUpdatedOnDescending => "timedesc",
            ArtifactManifestOrder.LastUpdatedOnAscending => "timeasc",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ArtifactManifestOrder value.")
        };

        public static ArtifactManifestOrder ToArtifactManifestOrder(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "none")) return ArtifactManifestOrder.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "timedesc")) return ArtifactManifestOrder.LastUpdatedOnDescending;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "timeasc")) return ArtifactManifestOrder.LastUpdatedOnAscending;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ArtifactManifestOrder value.");
        }
    }
}
