// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Containers.ContainerRegistry
{
    /// <summary> The artifact platform's architecture. </summary>
    public readonly partial struct ArtifactArchitecture : IEquatable<ArtifactArchitecture>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ArtifactArchitecture"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ArtifactArchitecture(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string I386Value = "386";
        private const string Amd64Value = "amd64";
        private const string ArmValue = "arm";
        private const string Arm64Value = "arm64";
        private const string MipsValue = "mips";
        private const string MipsLeValue = "mipsle";
        private const string Mips64Value = "mips64";
        private const string Mips64LeValue = "mips64le";
        private const string Ppc64Value = "ppc64";
        private const string Ppc64LeValue = "ppc64le";
        private const string RiscV64Value = "riscv64";
        private const string S390XValue = "s390x";
        private const string WasmValue = "wasm";

        /// <summary> i386. </summary>
        public static ArtifactArchitecture I386 { get; } = new ArtifactArchitecture(I386Value);
        /// <summary> AMD64. </summary>
        public static ArtifactArchitecture Amd64 { get; } = new ArtifactArchitecture(Amd64Value);
        /// <summary> ARM. </summary>
        public static ArtifactArchitecture Arm { get; } = new ArtifactArchitecture(ArmValue);
        /// <summary> ARM64. </summary>
        public static ArtifactArchitecture Arm64 { get; } = new ArtifactArchitecture(Arm64Value);
        /// <summary> MIPS. </summary>
        public static ArtifactArchitecture Mips { get; } = new ArtifactArchitecture(MipsValue);
        /// <summary> MIPSLE. </summary>
        public static ArtifactArchitecture MipsLe { get; } = new ArtifactArchitecture(MipsLeValue);
        /// <summary> MIPS64. </summary>
        public static ArtifactArchitecture Mips64 { get; } = new ArtifactArchitecture(Mips64Value);
        /// <summary> MIPS64LE. </summary>
        public static ArtifactArchitecture Mips64Le { get; } = new ArtifactArchitecture(Mips64LeValue);
        /// <summary> PPC64. </summary>
        public static ArtifactArchitecture Ppc64 { get; } = new ArtifactArchitecture(Ppc64Value);
        /// <summary> PPC64LE. </summary>
        public static ArtifactArchitecture Ppc64Le { get; } = new ArtifactArchitecture(Ppc64LeValue);
        /// <summary> RISCv64. </summary>
        public static ArtifactArchitecture RiscV64 { get; } = new ArtifactArchitecture(RiscV64Value);
        /// <summary> s390x. </summary>
        public static ArtifactArchitecture S390X { get; } = new ArtifactArchitecture(S390XValue);
        /// <summary> Wasm. </summary>
        public static ArtifactArchitecture Wasm { get; } = new ArtifactArchitecture(WasmValue);
        /// <summary> Determines if two <see cref="ArtifactArchitecture"/> values are the same. </summary>
        public static bool operator ==(ArtifactArchitecture left, ArtifactArchitecture right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ArtifactArchitecture"/> values are not the same. </summary>
        public static bool operator !=(ArtifactArchitecture left, ArtifactArchitecture right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ArtifactArchitecture"/>. </summary>
        public static implicit operator ArtifactArchitecture(string value) => new ArtifactArchitecture(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ArtifactArchitecture other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ArtifactArchitecture other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
