// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Containers.ContainerRegistry
{
    internal partial class AcrRefreshToken
    {
        internal static AcrRefreshToken DeserializeAcrRefreshToken(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string refreshToken = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("refresh_token"u8))
                {
                    refreshToken = property.Value.GetString();
                    continue;
                }
            }
            return new AcrRefreshToken(refreshToken);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcrRefreshToken FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcrRefreshToken(document.RootElement);
        }
    }
}
