// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Containers.ContainerRegistry
{
    internal partial class AcrManifests
    {
        internal static AcrManifests DeserializeAcrManifests(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string registry = default;
            string imageName = default;
            IReadOnlyList<ManifestAttributesBase> manifests = default;
            string link = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("registry"u8))
                {
                    registry = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("imageName"u8))
                {
                    imageName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("manifests"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ManifestAttributesBase> array = new List<ManifestAttributesBase>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ManifestAttributesBase.DeserializeManifestAttributesBase(item));
                    }
                    manifests = array;
                    continue;
                }
                if (property.NameEquals("link"u8))
                {
                    link = property.Value.GetString();
                    continue;
                }
            }
            return new AcrManifests(registry, imageName, manifests ?? new ChangeTrackingList<ManifestAttributesBase>(), link);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcrManifests FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcrManifests(document.RootElement);
        }
    }
}
