// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Containers.ContainerRegistry
{
    internal partial class AcrErrors
    {
        internal static AcrErrors DeserializeAcrErrors(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<AcrErrorInfo> errors = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("errors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AcrErrorInfo> array = new List<AcrErrorInfo>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AcrErrorInfo.DeserializeAcrErrorInfo(item));
                    }
                    errors = array;
                    continue;
                }
            }
            return new AcrErrors(errors ?? new ChangeTrackingList<AcrErrorInfo>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcrErrors FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcrErrors(document.RootElement);
        }
    }
}
