// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Containers.ContainerRegistry
{
    internal partial class AcrAccessToken
    {
        internal static AcrAccessToken DeserializeAcrAccessToken(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string accessToken = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("access_token"u8))
                {
                    accessToken = property.Value.GetString();
                    continue;
                }
            }
            return new AcrAccessToken(accessToken);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcrAccessToken FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcrAccessToken(document.RootElement);
        }
    }
}
