---
page_type: sample
languages:
- csharp
products:
- azure
- azure-container-registry
name: Azure.Containers.ContainerRegistry samples for .NET
description: Samples for the Azure.Containers.ContainerRegistry client library
---

# Azure.Containers.ContainerRegistry Samples

- Get started with the HelloWorld sample either [synchronously](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/containerregistry/Azure.Containers.ContainerRegistry/samples/Sample01a_HelloWorld.md) or [asynchronously](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/containerregistry/Azure.Containers.ContainerRegistry/samples/Sample01b_HelloWorldAsync.md).
- Manage a registry by deleting old images [synchronously](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/containerregistry/Azure.Containers.ContainerRegistry/samples/Sample02a_DeleteImages.md) or [asynchronously](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/containerregistry/Azure.Containers.ContainerRegistry/samples/Sample02b_DeleteImagesAsync.md).
- Set read/write/delete properties on an image [synchronously](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/containerregistry/Azure.Containers.ContainerRegistry/samples/Sample03a_SetImageProperties.md) or [asynchronously](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/containerregistry/Azure.Containers.ContainerRegistry/samples/Sample03b_SetImagePropertiesAsync.md).
- List tags on an image using an anonymous access client  [synchronously](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/containerregistry/Azure.Containers.ContainerRegistry/samples/Sample04a_AnonymousListTags.md) or [asynchronously](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/containerregistry/Azure.Containers.ContainerRegistry/samples/Sample04b_AnonymousListTagsAsync.md).
- Upload and download images [asynchronously](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/containerregistry/Azure.Containers.ContainerRegistry/samples/Sample05_UploadDownloadImage.md).
