// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerOrchestratorRuntime.Models
{
    /// <summary> Ability to expand volumes of a storage class. </summary>
    public readonly partial struct VolumeExpansion : IEquatable<VolumeExpansion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VolumeExpansion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VolumeExpansion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";
        private const string DisallowValue = "Disallow";

        /// <summary> Allow volume expansion. </summary>
        public static VolumeExpansion Allow { get; } = new VolumeExpansion(AllowValue);
        /// <summary> Disallow volume expansion. </summary>
        public static VolumeExpansion Disallow { get; } = new VolumeExpansion(DisallowValue);
        /// <summary> Determines if two <see cref="VolumeExpansion"/> values are the same. </summary>
        public static bool operator ==(VolumeExpansion left, VolumeExpansion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VolumeExpansion"/> values are not the same. </summary>
        public static bool operator !=(VolumeExpansion left, VolumeExpansion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VolumeExpansion"/>. </summary>
        public static implicit operator VolumeExpansion(string value) => new VolumeExpansion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VolumeExpansion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VolumeExpansion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
