// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ContainerOrchestratorRuntime.Models
{
    public partial class StorageClassTypePropertiesUpdate : IUtf8JsonSerializable, IJsonModel<StorageClassTypePropertiesUpdate>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<StorageClassTypePropertiesUpdate>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<StorageClassTypePropertiesUpdate>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageClassTypePropertiesUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageClassTypePropertiesUpdate)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(BackingStorageClassName))
            {
                writer.WritePropertyName("backingStorageClassName"u8);
                writer.WriteStringValue(BackingStorageClassName);
            }
            if (Optional.IsDefined(AzureStorageAccountName))
            {
                writer.WritePropertyName("azureStorageAccountName"u8);
                writer.WriteStringValue(AzureStorageAccountName);
            }
            if (Optional.IsDefined(AzureStorageAccountKey))
            {
                writer.WritePropertyName("azureStorageAccountKey"u8);
                writer.WriteStringValue(AzureStorageAccountKey);
            }
            if (Optional.IsDefined(Server))
            {
                writer.WritePropertyName("server"u8);
                writer.WriteStringValue(Server);
            }
            if (Optional.IsDefined(Share))
            {
                writer.WritePropertyName("share"u8);
                writer.WriteStringValue(Share);
            }
            if (Optional.IsDefined(SubDir))
            {
                writer.WritePropertyName("subDir"u8);
                writer.WriteStringValue(SubDir);
            }
            if (Optional.IsDefined(MountPermissions))
            {
                writer.WritePropertyName("mountPermissions"u8);
                writer.WriteStringValue(MountPermissions);
            }
            if (Optional.IsDefined(OnDelete))
            {
                writer.WritePropertyName("onDelete"u8);
                writer.WriteStringValue(OnDelete.Value.ToString());
            }
            if (Optional.IsDefined(Source))
            {
                writer.WritePropertyName("source"u8);
                writer.WriteStringValue(Source);
            }
            if (Optional.IsDefined(Username))
            {
                writer.WritePropertyName("username"u8);
                writer.WriteStringValue(Username);
            }
            if (Optional.IsDefined(Password))
            {
                writer.WritePropertyName("password"u8);
                writer.WriteStringValue(Password);
            }
            if (Optional.IsDefined(Domain))
            {
                writer.WritePropertyName("domain"u8);
                writer.WriteStringValue(Domain);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        StorageClassTypePropertiesUpdate IJsonModel<StorageClassTypePropertiesUpdate>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageClassTypePropertiesUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageClassTypePropertiesUpdate)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeStorageClassTypePropertiesUpdate(document.RootElement, options);
        }

        internal static StorageClassTypePropertiesUpdate DeserializeStorageClassTypePropertiesUpdate(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string backingStorageClassName = default;
            string azureStorageAccountName = default;
            string azureStorageAccountKey = default;
            string server = default;
            string share = default;
            string subDir = default;
            string mountPermissions = default;
            NfsDirectoryActionOnVolumeDeletion? onDelete = default;
            string source = default;
            string username = default;
            string password = default;
            string domain = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("backingStorageClassName"u8))
                {
                    backingStorageClassName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("azureStorageAccountName"u8))
                {
                    azureStorageAccountName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("azureStorageAccountKey"u8))
                {
                    azureStorageAccountKey = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("server"u8))
                {
                    server = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("share"u8))
                {
                    share = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("subDir"u8))
                {
                    subDir = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("mountPermissions"u8))
                {
                    mountPermissions = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("onDelete"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    onDelete = new NfsDirectoryActionOnVolumeDeletion(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("source"u8))
                {
                    source = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("username"u8))
                {
                    username = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("password"u8))
                {
                    password = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("domain"u8))
                {
                    domain = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new StorageClassTypePropertiesUpdate(
                backingStorageClassName,
                azureStorageAccountName,
                azureStorageAccountKey,
                server,
                share,
                subDir,
                mountPermissions,
                onDelete,
                source,
                username,
                password,
                domain,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<StorageClassTypePropertiesUpdate>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageClassTypePropertiesUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(StorageClassTypePropertiesUpdate)} does not support writing '{options.Format}' format.");
            }
        }

        StorageClassTypePropertiesUpdate IPersistableModel<StorageClassTypePropertiesUpdate>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageClassTypePropertiesUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeStorageClassTypePropertiesUpdate(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(StorageClassTypePropertiesUpdate)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<StorageClassTypePropertiesUpdate>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
