// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerOrchestratorRuntime.Models
{
    /// <summary> Type of a storage class. </summary>
    internal readonly partial struct StorageClassType : IEquatable<StorageClassType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageClassType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageClassType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NativeValue = "Native";
        private const string RwxValue = "RWX";
        private const string BlobValue = "Blob";
        private const string NfsValue = "NFS";
        private const string SmbValue = "SMB";

        /// <summary> Native storage class. </summary>
        public static StorageClassType Native { get; } = new StorageClassType(NativeValue);
        /// <summary> RWX storage class. </summary>
        public static StorageClassType Rwx { get; } = new StorageClassType(RwxValue);
        /// <summary> Blob storage class. </summary>
        public static StorageClassType Blob { get; } = new StorageClassType(BlobValue);
        /// <summary> NFS storage class. </summary>
        public static StorageClassType Nfs { get; } = new StorageClassType(NfsValue);
        /// <summary> SMB storage class. </summary>
        public static StorageClassType Smb { get; } = new StorageClassType(SmbValue);
        /// <summary> Determines if two <see cref="StorageClassType"/> values are the same. </summary>
        public static bool operator ==(StorageClassType left, StorageClassType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageClassType"/> values are not the same. </summary>
        public static bool operator !=(StorageClassType left, StorageClassType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageClassType"/>. </summary>
        public static implicit operator StorageClassType(string value) => new StorageClassType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageClassType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageClassType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
