// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ContainerOrchestratorRuntime.Models
{
    public partial class StorageClassPropertiesUpdate : IUtf8JsonSerializable, IJsonModel<StorageClassPropertiesUpdate>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<StorageClassPropertiesUpdate>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<StorageClassPropertiesUpdate>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageClassPropertiesUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageClassPropertiesUpdate)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(AllowVolumeExpansion))
            {
                writer.WritePropertyName("allowVolumeExpansion"u8);
                writer.WriteStringValue(AllowVolumeExpansion.Value.ToString());
            }
            if (Optional.IsCollectionDefined(MountOptions))
            {
                writer.WritePropertyName("mountOptions"u8);
                writer.WriteStartArray();
                foreach (var item in MountOptions)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(AccessModes))
            {
                writer.WritePropertyName("accessModes"u8);
                writer.WriteStartArray();
                foreach (var item in AccessModes)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(DataResilience))
            {
                writer.WritePropertyName("dataResilience"u8);
                writer.WriteStringValue(DataResilience.Value.ToString());
            }
            if (Optional.IsDefined(FailoverSpeed))
            {
                writer.WritePropertyName("failoverSpeed"u8);
                writer.WriteStringValue(FailoverSpeed.Value.ToString());
            }
            if (Optional.IsCollectionDefined(Limitations))
            {
                writer.WritePropertyName("limitations"u8);
                writer.WriteStartArray();
                foreach (var item in Limitations)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Performance))
            {
                writer.WritePropertyName("performance"u8);
                writer.WriteStringValue(Performance.Value.ToString());
            }
            if (Optional.IsDefined(Priority))
            {
                writer.WritePropertyName("priority"u8);
                writer.WriteNumberValue(Priority.Value);
            }
            if (Optional.IsDefined(TypeProperties))
            {
                writer.WritePropertyName("typeProperties"u8);
                writer.WriteObjectValue(TypeProperties, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        StorageClassPropertiesUpdate IJsonModel<StorageClassPropertiesUpdate>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageClassPropertiesUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageClassPropertiesUpdate)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeStorageClassPropertiesUpdate(document.RootElement, options);
        }

        internal static StorageClassPropertiesUpdate DeserializeStorageClassPropertiesUpdate(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            VolumeExpansion? allowVolumeExpansion = default;
            IList<string> mountOptions = default;
            IList<StorageClassAccessMode> accessModes = default;
            DataResilienceTier? dataResilience = default;
            FailoverTier? failoverSpeed = default;
            IList<string> limitations = default;
            PerformanceTier? performance = default;
            long? priority = default;
            StorageClassTypePropertiesUpdate typeProperties = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("allowVolumeExpansion"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allowVolumeExpansion = new VolumeExpansion(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("mountOptions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    mountOptions = array;
                    continue;
                }
                if (property.NameEquals("accessModes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<StorageClassAccessMode> array = new List<StorageClassAccessMode>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new StorageClassAccessMode(item.GetString()));
                    }
                    accessModes = array;
                    continue;
                }
                if (property.NameEquals("dataResilience"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataResilience = new DataResilienceTier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("failoverSpeed"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    failoverSpeed = new FailoverTier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("limitations"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    limitations = array;
                    continue;
                }
                if (property.NameEquals("performance"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    performance = new PerformanceTier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("priority"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    priority = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("typeProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    typeProperties = StorageClassTypePropertiesUpdate.DeserializeStorageClassTypePropertiesUpdate(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new StorageClassPropertiesUpdate(
                allowVolumeExpansion,
                mountOptions ?? new ChangeTrackingList<string>(),
                accessModes ?? new ChangeTrackingList<StorageClassAccessMode>(),
                dataResilience,
                failoverSpeed,
                limitations ?? new ChangeTrackingList<string>(),
                performance,
                priority,
                typeProperties,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<StorageClassPropertiesUpdate>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageClassPropertiesUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(StorageClassPropertiesUpdate)} does not support writing '{options.Format}' format.");
            }
        }

        StorageClassPropertiesUpdate IPersistableModel<StorageClassPropertiesUpdate>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageClassPropertiesUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeStorageClassPropertiesUpdate(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(StorageClassPropertiesUpdate)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<StorageClassPropertiesUpdate>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
