// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerOrchestratorRuntime.Models
{
    /// <summary> Storage Class Access Mode. </summary>
    public readonly partial struct StorageClassAccessMode : IEquatable<StorageClassAccessMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageClassAccessMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageClassAccessMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ReadWriteOnceValue = "ReadWriteOnce";
        private const string ReadWriteManyValue = "ReadWriteMany";

        /// <summary> Read Write Once (RWO) access mode. </summary>
        public static StorageClassAccessMode ReadWriteOnce { get; } = new StorageClassAccessMode(ReadWriteOnceValue);
        /// <summary> Read Write Many (RWX) access mode. </summary>
        public static StorageClassAccessMode ReadWriteMany { get; } = new StorageClassAccessMode(ReadWriteManyValue);
        /// <summary> Determines if two <see cref="StorageClassAccessMode"/> values are the same. </summary>
        public static bool operator ==(StorageClassAccessMode left, StorageClassAccessMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageClassAccessMode"/> values are not the same. </summary>
        public static bool operator !=(StorageClassAccessMode left, StorageClassAccessMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageClassAccessMode"/>. </summary>
        public static implicit operator StorageClassAccessMode(string value) => new StorageClassAccessMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageClassAccessMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageClassAccessMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
