// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerOrchestratorRuntime.Models
{
    /// <summary> The properties of RWX StorageClass. </summary>
    public partial class RwxStorageClassTypeProperties : StorageClassTypeProperties
    {
        /// <summary> Initializes a new instance of <see cref="RwxStorageClassTypeProperties"/>. </summary>
        /// <param name="backingStorageClassName"> The backing storageclass used to create new storageclass. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="backingStorageClassName"/> is null. </exception>
        public RwxStorageClassTypeProperties(string backingStorageClassName)
        {
            Argument.AssertNotNull(backingStorageClassName, nameof(backingStorageClassName));

            BackingStorageClassName = backingStorageClassName;
            Type = StorageClassType.Rwx;
        }

        /// <summary> Initializes a new instance of <see cref="RwxStorageClassTypeProperties"/>. </summary>
        /// <param name="type"> Type of the storage class. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="backingStorageClassName"> The backing storageclass used to create new storageclass. </param>
        internal RwxStorageClassTypeProperties(StorageClassType type, IDictionary<string, BinaryData> serializedAdditionalRawData, string backingStorageClassName) : base(type, serializedAdditionalRawData)
        {
            BackingStorageClassName = backingStorageClassName;
            Type = type;
        }

        /// <summary> Initializes a new instance of <see cref="RwxStorageClassTypeProperties"/> for deserialization. </summary>
        internal RwxStorageClassTypeProperties()
        {
        }

        /// <summary> The backing storageclass used to create new storageclass. </summary>
        public string BackingStorageClassName { get; set; }
    }
}
