// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ContainerOrchestratorRuntime.Models
{
    public partial class NfsStorageClassTypeProperties : IUtf8JsonSerializable, IJsonModel<NfsStorageClassTypeProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<NfsStorageClassTypeProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<NfsStorageClassTypeProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NfsStorageClassTypeProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NfsStorageClassTypeProperties)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("server"u8);
            writer.WriteStringValue(Server);
            writer.WritePropertyName("share"u8);
            writer.WriteStringValue(Share);
            if (Optional.IsDefined(SubDir))
            {
                writer.WritePropertyName("subDir"u8);
                writer.WriteStringValue(SubDir);
            }
            if (Optional.IsDefined(MountPermissions))
            {
                writer.WritePropertyName("mountPermissions"u8);
                writer.WriteStringValue(MountPermissions);
            }
            if (Optional.IsDefined(OnDelete))
            {
                writer.WritePropertyName("onDelete"u8);
                writer.WriteStringValue(OnDelete.Value.ToString());
            }
        }

        NfsStorageClassTypeProperties IJsonModel<NfsStorageClassTypeProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NfsStorageClassTypeProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NfsStorageClassTypeProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeNfsStorageClassTypeProperties(document.RootElement, options);
        }

        internal static NfsStorageClassTypeProperties DeserializeNfsStorageClassTypeProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string server = default;
            string share = default;
            string subDir = default;
            string mountPermissions = default;
            NfsDirectoryActionOnVolumeDeletion? onDelete = default;
            StorageClassType type = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("server"u8))
                {
                    server = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("share"u8))
                {
                    share = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("subDir"u8))
                {
                    subDir = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("mountPermissions"u8))
                {
                    mountPermissions = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("onDelete"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    onDelete = new NfsDirectoryActionOnVolumeDeletion(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new StorageClassType(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new NfsStorageClassTypeProperties(
                type,
                serializedAdditionalRawData,
                server,
                share,
                subDir,
                mountPermissions,
                onDelete);
        }

        BinaryData IPersistableModel<NfsStorageClassTypeProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NfsStorageClassTypeProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(NfsStorageClassTypeProperties)} does not support writing '{options.Format}' format.");
            }
        }

        NfsStorageClassTypeProperties IPersistableModel<NfsStorageClassTypeProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NfsStorageClassTypeProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeNfsStorageClassTypeProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(NfsStorageClassTypeProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<NfsStorageClassTypeProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
