// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerOrchestratorRuntime.Models
{
    /// <summary> Data resilience tier of a storage class. </summary>
    public readonly partial struct DataResilienceTier : IEquatable<DataResilienceTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataResilienceTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataResilienceTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotDataResilientValue = "NotDataResilient";
        private const string DataResilientValue = "DataResilient";

        /// <summary> Not data resilient. </summary>
        public static DataResilienceTier NotDataResilient { get; } = new DataResilienceTier(NotDataResilientValue);
        /// <summary> Data resilient. </summary>
        public static DataResilienceTier DataResilient { get; } = new DataResilienceTier(DataResilientValue);
        /// <summary> Determines if two <see cref="DataResilienceTier"/> values are the same. </summary>
        public static bool operator ==(DataResilienceTier left, DataResilienceTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataResilienceTier"/> values are not the same. </summary>
        public static bool operator !=(DataResilienceTier left, DataResilienceTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataResilienceTier"/>. </summary>
        public static implicit operator DataResilienceTier(string value) => new DataResilienceTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataResilienceTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataResilienceTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
