// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerOrchestratorRuntime.Models
{
    /// <summary> Enum of advertise mode. </summary>
    public readonly partial struct AdvertiseMode : IEquatable<AdvertiseMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AdvertiseMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AdvertiseMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ArpValue = "ARP";
        private const string BgpValue = "BGP";
        private const string BothValue = "Both";

        /// <summary> ARP advertise mode. </summary>
        public static AdvertiseMode Arp { get; } = new AdvertiseMode(ArpValue);
        /// <summary> BGP advertise mode. </summary>
        public static AdvertiseMode Bgp { get; } = new AdvertiseMode(BgpValue);
        /// <summary> both ARP and BGP advertise mode. </summary>
        public static AdvertiseMode Both { get; } = new AdvertiseMode(BothValue);
        /// <summary> Determines if two <see cref="AdvertiseMode"/> values are the same. </summary>
        public static bool operator ==(AdvertiseMode left, AdvertiseMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AdvertiseMode"/> values are not the same. </summary>
        public static bool operator !=(AdvertiseMode left, AdvertiseMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AdvertiseMode"/>. </summary>
        public static implicit operator AdvertiseMode(string value) => new AdvertiseMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AdvertiseMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AdvertiseMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
