// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ContainerOrchestratorRuntime
{
    internal class ConnectedClusterStorageClassOperationSource : IOperationSource<ConnectedClusterStorageClassResource>
    {
        private readonly ArmClient _client;

        internal ConnectedClusterStorageClassOperationSource(ArmClient client)
        {
            _client = client;
        }

        ConnectedClusterStorageClassResource IOperationSource<ConnectedClusterStorageClassResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ConnectedClusterStorageClassData.DeserializeConnectedClusterStorageClassData(document.RootElement);
            return new ConnectedClusterStorageClassResource(_client, data);
        }

        async ValueTask<ConnectedClusterStorageClassResource> IOperationSource<ConnectedClusterStorageClassResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ConnectedClusterStorageClassData.DeserializeConnectedClusterStorageClassData(document.RootElement);
            return new ConnectedClusterStorageClassResource(_client, data);
        }
    }
}
