// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ContainerOrchestratorRuntime
{
    internal class ConnectedClusterLoadBalancerOperationSource : IOperationSource<ConnectedClusterLoadBalancerResource>
    {
        private readonly ArmClient _client;

        internal ConnectedClusterLoadBalancerOperationSource(ArmClient client)
        {
            _client = client;
        }

        ConnectedClusterLoadBalancerResource IOperationSource<ConnectedClusterLoadBalancerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ConnectedClusterLoadBalancerData.DeserializeConnectedClusterLoadBalancerData(document.RootElement);
            return new ConnectedClusterLoadBalancerResource(_client, data);
        }

        async ValueTask<ConnectedClusterLoadBalancerResource> IOperationSource<ConnectedClusterLoadBalancerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ConnectedClusterLoadBalancerData.DeserializeConnectedClusterLoadBalancerData(document.RootElement);
            return new ConnectedClusterLoadBalancerResource(_client, data);
        }
    }
}
