// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.ContainerOrchestratorRuntime.Mocking;

namespace Azure.ResourceManager.ContainerOrchestratorRuntime
{
    /// <summary> A class to add extension methods to Azure.ResourceManager.ContainerOrchestratorRuntime. </summary>
    public static partial class ContainerOrchestratorRuntimeExtensions
    {
        private static MockableContainerOrchestratorRuntimeArmClient GetMockableContainerOrchestratorRuntimeArmClient(ArmClient client)
        {
            return client.GetCachedClient(client0 => new MockableContainerOrchestratorRuntimeArmClient(client0));
        }

        /// <summary>
        /// Gets a collection of ConnectedClusterStorageClassResources in the ArmClient.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableContainerOrchestratorRuntimeArmClient.GetConnectedClusterStorageClasses(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> An object representing collection of ConnectedClusterStorageClassResources and their operations over a ConnectedClusterStorageClassResource. </returns>
        public static ConnectedClusterStorageClassCollection GetConnectedClusterStorageClasses(this ArmClient client, ResourceIdentifier scope)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableContainerOrchestratorRuntimeArmClient(client).GetConnectedClusterStorageClasses(scope);
        }

        /// <summary>
        /// Get a StorageClassResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/storageClasses/{storageClassName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageClassResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterStorageClassResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableContainerOrchestratorRuntimeArmClient.GetConnectedClusterStorageClassAsync(ResourceIdentifier,string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="storageClassName"> The name of the the storage class. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> or <paramref name="storageClassName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="storageClassName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static async Task<Response<ConnectedClusterStorageClassResource>> GetConnectedClusterStorageClassAsync(this ArmClient client, ResourceIdentifier scope, string storageClassName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(client, nameof(client));

            return await GetMockableContainerOrchestratorRuntimeArmClient(client).GetConnectedClusterStorageClassAsync(scope, storageClassName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a StorageClassResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/storageClasses/{storageClassName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageClassResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterStorageClassResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableContainerOrchestratorRuntimeArmClient.GetConnectedClusterStorageClass(ResourceIdentifier,string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="storageClassName"> The name of the the storage class. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> or <paramref name="storageClassName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="storageClassName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static Response<ConnectedClusterStorageClassResource> GetConnectedClusterStorageClass(this ArmClient client, ResourceIdentifier scope, string storageClassName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableContainerOrchestratorRuntimeArmClient(client).GetConnectedClusterStorageClass(scope, storageClassName, cancellationToken);
        }

        /// <summary>
        /// Gets a collection of ConnectedClusterLoadBalancerResources in the ArmClient.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableContainerOrchestratorRuntimeArmClient.GetConnectedClusterLoadBalancers(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> An object representing collection of ConnectedClusterLoadBalancerResources and their operations over a ConnectedClusterLoadBalancerResource. </returns>
        public static ConnectedClusterLoadBalancerCollection GetConnectedClusterLoadBalancers(this ArmClient client, ResourceIdentifier scope)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableContainerOrchestratorRuntimeArmClient(client).GetConnectedClusterLoadBalancers(scope);
        }

        /// <summary>
        /// Get a LoadBalancer
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/loadBalancers/{loadBalancerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LoadBalancer_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterLoadBalancerResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableContainerOrchestratorRuntimeArmClient.GetConnectedClusterLoadBalancerAsync(ResourceIdentifier,string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="loadBalancerName"> The name of the LoadBalancer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> or <paramref name="loadBalancerName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="loadBalancerName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static async Task<Response<ConnectedClusterLoadBalancerResource>> GetConnectedClusterLoadBalancerAsync(this ArmClient client, ResourceIdentifier scope, string loadBalancerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(client, nameof(client));

            return await GetMockableContainerOrchestratorRuntimeArmClient(client).GetConnectedClusterLoadBalancerAsync(scope, loadBalancerName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a LoadBalancer
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/loadBalancers/{loadBalancerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LoadBalancer_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterLoadBalancerResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableContainerOrchestratorRuntimeArmClient.GetConnectedClusterLoadBalancer(ResourceIdentifier,string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="loadBalancerName"> The name of the LoadBalancer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> or <paramref name="loadBalancerName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="loadBalancerName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static Response<ConnectedClusterLoadBalancerResource> GetConnectedClusterLoadBalancer(this ArmClient client, ResourceIdentifier scope, string loadBalancerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableContainerOrchestratorRuntimeArmClient(client).GetConnectedClusterLoadBalancer(scope, loadBalancerName, cancellationToken);
        }

        /// <summary>
        /// Gets a collection of ConnectedClusterBgpPeerResources in the ArmClient.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableContainerOrchestratorRuntimeArmClient.GetConnectedClusterBgpPeers(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> An object representing collection of ConnectedClusterBgpPeerResources and their operations over a ConnectedClusterBgpPeerResource. </returns>
        public static ConnectedClusterBgpPeerCollection GetConnectedClusterBgpPeers(this ArmClient client, ResourceIdentifier scope)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableContainerOrchestratorRuntimeArmClient(client).GetConnectedClusterBgpPeers(scope);
        }

        /// <summary>
        /// Get a BgpPeer
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/bgpPeers/{bgpPeerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BgpPeer_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterBgpPeerResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableContainerOrchestratorRuntimeArmClient.GetConnectedClusterBgpPeerAsync(ResourceIdentifier,string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="bgpPeerName"> The name of the BgpPeer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> or <paramref name="bgpPeerName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="bgpPeerName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static async Task<Response<ConnectedClusterBgpPeerResource>> GetConnectedClusterBgpPeerAsync(this ArmClient client, ResourceIdentifier scope, string bgpPeerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(client, nameof(client));

            return await GetMockableContainerOrchestratorRuntimeArmClient(client).GetConnectedClusterBgpPeerAsync(scope, bgpPeerName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a BgpPeer
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/bgpPeers/{bgpPeerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BgpPeer_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterBgpPeerResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableContainerOrchestratorRuntimeArmClient.GetConnectedClusterBgpPeer(ResourceIdentifier,string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="bgpPeerName"> The name of the BgpPeer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> or <paramref name="bgpPeerName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="bgpPeerName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static Response<ConnectedClusterBgpPeerResource> GetConnectedClusterBgpPeer(this ArmClient client, ResourceIdentifier scope, string bgpPeerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableContainerOrchestratorRuntimeArmClient(client).GetConnectedClusterBgpPeer(scope, bgpPeerName, cancellationToken);
        }

        /// <summary>
        /// Gets a collection of ConnectedClusterServiceResources in the ArmClient.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableContainerOrchestratorRuntimeArmClient.GetConnectedClusterServices(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> An object representing collection of ConnectedClusterServiceResources and their operations over a ConnectedClusterServiceResource. </returns>
        public static ConnectedClusterServiceCollection GetConnectedClusterServices(this ArmClient client, ResourceIdentifier scope)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableContainerOrchestratorRuntimeArmClient(client).GetConnectedClusterServices(scope);
        }

        /// <summary>
        /// Get a ServiceResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/services/{serviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServiceResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterServiceResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableContainerOrchestratorRuntimeArmClient.GetConnectedClusterServiceAsync(ResourceIdentifier,string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="serviceName"> The name of the the service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> or <paramref name="serviceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="serviceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static async Task<Response<ConnectedClusterServiceResource>> GetConnectedClusterServiceAsync(this ArmClient client, ResourceIdentifier scope, string serviceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(client, nameof(client));

            return await GetMockableContainerOrchestratorRuntimeArmClient(client).GetConnectedClusterServiceAsync(scope, serviceName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a ServiceResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/services/{serviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServiceResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterServiceResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableContainerOrchestratorRuntimeArmClient.GetConnectedClusterService(ResourceIdentifier,string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="serviceName"> The name of the the service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> or <paramref name="serviceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="serviceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static Response<ConnectedClusterServiceResource> GetConnectedClusterService(this ArmClient client, ResourceIdentifier scope, string serviceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableContainerOrchestratorRuntimeArmClient(client).GetConnectedClusterService(scope, serviceName, cancellationToken);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ConnectedClusterStorageClassResource" /> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ConnectedClusterStorageClassResource.CreateResourceIdentifier" /> to create a <see cref="ConnectedClusterStorageClassResource" /> <see cref="ResourceIdentifier" /> from its components.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableContainerOrchestratorRuntimeArmClient.GetConnectedClusterStorageClassResource(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> Returns a <see cref="ConnectedClusterStorageClassResource"/> object. </returns>
        public static ConnectedClusterStorageClassResource GetConnectedClusterStorageClassResource(this ArmClient client, ResourceIdentifier id)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableContainerOrchestratorRuntimeArmClient(client).GetConnectedClusterStorageClassResource(id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ConnectedClusterLoadBalancerResource" /> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ConnectedClusterLoadBalancerResource.CreateResourceIdentifier" /> to create a <see cref="ConnectedClusterLoadBalancerResource" /> <see cref="ResourceIdentifier" /> from its components.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableContainerOrchestratorRuntimeArmClient.GetConnectedClusterLoadBalancerResource(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> Returns a <see cref="ConnectedClusterLoadBalancerResource"/> object. </returns>
        public static ConnectedClusterLoadBalancerResource GetConnectedClusterLoadBalancerResource(this ArmClient client, ResourceIdentifier id)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableContainerOrchestratorRuntimeArmClient(client).GetConnectedClusterLoadBalancerResource(id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ConnectedClusterBgpPeerResource" /> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ConnectedClusterBgpPeerResource.CreateResourceIdentifier" /> to create a <see cref="ConnectedClusterBgpPeerResource" /> <see cref="ResourceIdentifier" /> from its components.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableContainerOrchestratorRuntimeArmClient.GetConnectedClusterBgpPeerResource(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> Returns a <see cref="ConnectedClusterBgpPeerResource"/> object. </returns>
        public static ConnectedClusterBgpPeerResource GetConnectedClusterBgpPeerResource(this ArmClient client, ResourceIdentifier id)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableContainerOrchestratorRuntimeArmClient(client).GetConnectedClusterBgpPeerResource(id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ConnectedClusterServiceResource" /> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ConnectedClusterServiceResource.CreateResourceIdentifier" /> to create a <see cref="ConnectedClusterServiceResource" /> <see cref="ResourceIdentifier" /> from its components.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableContainerOrchestratorRuntimeArmClient.GetConnectedClusterServiceResource(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> Returns a <see cref="ConnectedClusterServiceResource"/> object. </returns>
        public static ConnectedClusterServiceResource GetConnectedClusterServiceResource(this ArmClient client, ResourceIdentifier id)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableContainerOrchestratorRuntimeArmClient(client).GetConnectedClusterServiceResource(id);
        }
    }
}
