// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.ContainerOrchestratorRuntime
{
    /// <summary>
    /// A class representing a collection of <see cref="ConnectedClusterStorageClassResource"/> and their operations.
    /// Each <see cref="ConnectedClusterStorageClassResource"/> in the collection will belong to the same instance of <see cref="ArmResource"/>.
    /// To get a <see cref="ConnectedClusterStorageClassCollection"/> instance call the GetConnectedClusterStorageClasses method from an instance of <see cref="ArmResource"/>.
    /// </summary>
    public partial class ConnectedClusterStorageClassCollection : ArmCollection, IEnumerable<ConnectedClusterStorageClassResource>, IAsyncEnumerable<ConnectedClusterStorageClassResource>
    {
        private readonly ClientDiagnostics _connectedClusterStorageClassStorageClassClientDiagnostics;
        private readonly StorageClassRestOperations _connectedClusterStorageClassStorageClassRestClient;

        /// <summary> Initializes a new instance of the <see cref="ConnectedClusterStorageClassCollection"/> class for mocking. </summary>
        protected ConnectedClusterStorageClassCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ConnectedClusterStorageClassCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ConnectedClusterStorageClassCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _connectedClusterStorageClassStorageClassClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ContainerOrchestratorRuntime", ConnectedClusterStorageClassResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ConnectedClusterStorageClassResource.ResourceType, out string connectedClusterStorageClassStorageClassApiVersion);
            _connectedClusterStorageClassStorageClassRestClient = new StorageClassRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, connectedClusterStorageClassStorageClassApiVersion);
        }

        /// <summary>
        /// Create a StorageClassResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/storageClasses/{storageClassName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageClassResource_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterStorageClassResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="storageClassName"> The name of the the storage class. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="storageClassName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="storageClassName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ConnectedClusterStorageClassResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string storageClassName, ConnectedClusterStorageClassData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(storageClassName, nameof(storageClassName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _connectedClusterStorageClassStorageClassClientDiagnostics.CreateScope("ConnectedClusterStorageClassCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _connectedClusterStorageClassStorageClassRestClient.CreateOrUpdateAsync(Id, storageClassName, data, cancellationToken).ConfigureAwait(false);
                var operation = new ContainerOrchestratorRuntimeArmOperation<ConnectedClusterStorageClassResource>(new ConnectedClusterStorageClassOperationSource(Client), _connectedClusterStorageClassStorageClassClientDiagnostics, Pipeline, _connectedClusterStorageClassStorageClassRestClient.CreateCreateOrUpdateRequest(Id, storageClassName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a StorageClassResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/storageClasses/{storageClassName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageClassResource_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterStorageClassResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="storageClassName"> The name of the the storage class. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="storageClassName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="storageClassName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ConnectedClusterStorageClassResource> CreateOrUpdate(WaitUntil waitUntil, string storageClassName, ConnectedClusterStorageClassData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(storageClassName, nameof(storageClassName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _connectedClusterStorageClassStorageClassClientDiagnostics.CreateScope("ConnectedClusterStorageClassCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _connectedClusterStorageClassStorageClassRestClient.CreateOrUpdate(Id, storageClassName, data, cancellationToken);
                var operation = new ContainerOrchestratorRuntimeArmOperation<ConnectedClusterStorageClassResource>(new ConnectedClusterStorageClassOperationSource(Client), _connectedClusterStorageClassStorageClassClientDiagnostics, Pipeline, _connectedClusterStorageClassStorageClassRestClient.CreateCreateOrUpdateRequest(Id, storageClassName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a StorageClassResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/storageClasses/{storageClassName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageClassResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterStorageClassResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="storageClassName"> The name of the the storage class. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="storageClassName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="storageClassName"/> is null. </exception>
        public virtual async Task<Response<ConnectedClusterStorageClassResource>> GetAsync(string storageClassName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(storageClassName, nameof(storageClassName));

            using var scope = _connectedClusterStorageClassStorageClassClientDiagnostics.CreateScope("ConnectedClusterStorageClassCollection.Get");
            scope.Start();
            try
            {
                var response = await _connectedClusterStorageClassStorageClassRestClient.GetAsync(Id, storageClassName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ConnectedClusterStorageClassResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a StorageClassResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/storageClasses/{storageClassName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageClassResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterStorageClassResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="storageClassName"> The name of the the storage class. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="storageClassName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="storageClassName"/> is null. </exception>
        public virtual Response<ConnectedClusterStorageClassResource> Get(string storageClassName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(storageClassName, nameof(storageClassName));

            using var scope = _connectedClusterStorageClassStorageClassClientDiagnostics.CreateScope("ConnectedClusterStorageClassCollection.Get");
            scope.Start();
            try
            {
                var response = _connectedClusterStorageClassStorageClassRestClient.Get(Id, storageClassName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ConnectedClusterStorageClassResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List StorageClassResource resources by parent
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/storageClasses</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageClassResource_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterStorageClassResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ConnectedClusterStorageClassResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ConnectedClusterStorageClassResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _connectedClusterStorageClassStorageClassRestClient.CreateListRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _connectedClusterStorageClassStorageClassRestClient.CreateListNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ConnectedClusterStorageClassResource(Client, ConnectedClusterStorageClassData.DeserializeConnectedClusterStorageClassData(e)), _connectedClusterStorageClassStorageClassClientDiagnostics, Pipeline, "ConnectedClusterStorageClassCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List StorageClassResource resources by parent
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/storageClasses</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageClassResource_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterStorageClassResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ConnectedClusterStorageClassResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ConnectedClusterStorageClassResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _connectedClusterStorageClassStorageClassRestClient.CreateListRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _connectedClusterStorageClassStorageClassRestClient.CreateListNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ConnectedClusterStorageClassResource(Client, ConnectedClusterStorageClassData.DeserializeConnectedClusterStorageClassData(e)), _connectedClusterStorageClassStorageClassClientDiagnostics, Pipeline, "ConnectedClusterStorageClassCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/storageClasses/{storageClassName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageClassResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterStorageClassResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="storageClassName"> The name of the the storage class. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="storageClassName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="storageClassName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string storageClassName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(storageClassName, nameof(storageClassName));

            using var scope = _connectedClusterStorageClassStorageClassClientDiagnostics.CreateScope("ConnectedClusterStorageClassCollection.Exists");
            scope.Start();
            try
            {
                var response = await _connectedClusterStorageClassStorageClassRestClient.GetAsync(Id, storageClassName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/storageClasses/{storageClassName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageClassResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterStorageClassResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="storageClassName"> The name of the the storage class. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="storageClassName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="storageClassName"/> is null. </exception>
        public virtual Response<bool> Exists(string storageClassName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(storageClassName, nameof(storageClassName));

            using var scope = _connectedClusterStorageClassStorageClassClientDiagnostics.CreateScope("ConnectedClusterStorageClassCollection.Exists");
            scope.Start();
            try
            {
                var response = _connectedClusterStorageClassStorageClassRestClient.Get(Id, storageClassName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/storageClasses/{storageClassName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageClassResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterStorageClassResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="storageClassName"> The name of the the storage class. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="storageClassName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="storageClassName"/> is null. </exception>
        public virtual async Task<NullableResponse<ConnectedClusterStorageClassResource>> GetIfExistsAsync(string storageClassName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(storageClassName, nameof(storageClassName));

            using var scope = _connectedClusterStorageClassStorageClassClientDiagnostics.CreateScope("ConnectedClusterStorageClassCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _connectedClusterStorageClassStorageClassRestClient.GetAsync(Id, storageClassName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ConnectedClusterStorageClassResource>(response.GetRawResponse());
                return Response.FromValue(new ConnectedClusterStorageClassResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/storageClasses/{storageClassName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageClassResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterStorageClassResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="storageClassName"> The name of the the storage class. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="storageClassName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="storageClassName"/> is null. </exception>
        public virtual NullableResponse<ConnectedClusterStorageClassResource> GetIfExists(string storageClassName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(storageClassName, nameof(storageClassName));

            using var scope = _connectedClusterStorageClassStorageClassClientDiagnostics.CreateScope("ConnectedClusterStorageClassCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _connectedClusterStorageClassStorageClassRestClient.Get(Id, storageClassName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ConnectedClusterStorageClassResource>(response.GetRawResponse());
                return Response.FromValue(new ConnectedClusterStorageClassResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ConnectedClusterStorageClassResource> IEnumerable<ConnectedClusterStorageClassResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ConnectedClusterStorageClassResource> IAsyncEnumerable<ConnectedClusterStorageClassResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
