// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.ContainerOrchestratorRuntime
{
    /// <summary>
    /// A class representing a collection of <see cref="ConnectedClusterServiceResource"/> and their operations.
    /// Each <see cref="ConnectedClusterServiceResource"/> in the collection will belong to the same instance of <see cref="ArmResource"/>.
    /// To get a <see cref="ConnectedClusterServiceCollection"/> instance call the GetConnectedClusterServices method from an instance of <see cref="ArmResource"/>.
    /// </summary>
    public partial class ConnectedClusterServiceCollection : ArmCollection, IEnumerable<ConnectedClusterServiceResource>, IAsyncEnumerable<ConnectedClusterServiceResource>
    {
        private readonly ClientDiagnostics _connectedClusterServiceServicesClientDiagnostics;
        private readonly ServicesRestOperations _connectedClusterServiceServicesRestClient;

        /// <summary> Initializes a new instance of the <see cref="ConnectedClusterServiceCollection"/> class for mocking. </summary>
        protected ConnectedClusterServiceCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ConnectedClusterServiceCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ConnectedClusterServiceCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _connectedClusterServiceServicesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ContainerOrchestratorRuntime", ConnectedClusterServiceResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ConnectedClusterServiceResource.ResourceType, out string connectedClusterServiceServicesApiVersion);
            _connectedClusterServiceServicesRestClient = new ServicesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, connectedClusterServiceServicesApiVersion);
        }

        /// <summary>
        /// Create a ServiceResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/services/{serviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServiceResource_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="serviceName"> The name of the the service. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="serviceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="serviceName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ConnectedClusterServiceResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string serviceName, ConnectedClusterServiceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(serviceName, nameof(serviceName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _connectedClusterServiceServicesClientDiagnostics.CreateScope("ConnectedClusterServiceCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _connectedClusterServiceServicesRestClient.CreateOrUpdateAsync(Id, serviceName, data, cancellationToken).ConfigureAwait(false);
                var uri = _connectedClusterServiceServicesRestClient.CreateCreateOrUpdateRequestUri(Id, serviceName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ContainerOrchestratorRuntimeArmOperation<ConnectedClusterServiceResource>(Response.FromValue(new ConnectedClusterServiceResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a ServiceResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/services/{serviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServiceResource_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="serviceName"> The name of the the service. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="serviceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="serviceName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ConnectedClusterServiceResource> CreateOrUpdate(WaitUntil waitUntil, string serviceName, ConnectedClusterServiceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(serviceName, nameof(serviceName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _connectedClusterServiceServicesClientDiagnostics.CreateScope("ConnectedClusterServiceCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _connectedClusterServiceServicesRestClient.CreateOrUpdate(Id, serviceName, data, cancellationToken);
                var uri = _connectedClusterServiceServicesRestClient.CreateCreateOrUpdateRequestUri(Id, serviceName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ContainerOrchestratorRuntimeArmOperation<ConnectedClusterServiceResource>(Response.FromValue(new ConnectedClusterServiceResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a ServiceResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/services/{serviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServiceResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="serviceName"> The name of the the service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="serviceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="serviceName"/> is null. </exception>
        public virtual async Task<Response<ConnectedClusterServiceResource>> GetAsync(string serviceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(serviceName, nameof(serviceName));

            using var scope = _connectedClusterServiceServicesClientDiagnostics.CreateScope("ConnectedClusterServiceCollection.Get");
            scope.Start();
            try
            {
                var response = await _connectedClusterServiceServicesRestClient.GetAsync(Id, serviceName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ConnectedClusterServiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a ServiceResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/services/{serviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServiceResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="serviceName"> The name of the the service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="serviceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="serviceName"/> is null. </exception>
        public virtual Response<ConnectedClusterServiceResource> Get(string serviceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(serviceName, nameof(serviceName));

            using var scope = _connectedClusterServiceServicesClientDiagnostics.CreateScope("ConnectedClusterServiceCollection.Get");
            scope.Start();
            try
            {
                var response = _connectedClusterServiceServicesRestClient.Get(Id, serviceName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ConnectedClusterServiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List ServiceResource resources by parent
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/services</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServiceResource_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ConnectedClusterServiceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ConnectedClusterServiceResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _connectedClusterServiceServicesRestClient.CreateListRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _connectedClusterServiceServicesRestClient.CreateListNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ConnectedClusterServiceResource(Client, ConnectedClusterServiceData.DeserializeConnectedClusterServiceData(e)), _connectedClusterServiceServicesClientDiagnostics, Pipeline, "ConnectedClusterServiceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List ServiceResource resources by parent
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/services</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServiceResource_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ConnectedClusterServiceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ConnectedClusterServiceResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _connectedClusterServiceServicesRestClient.CreateListRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _connectedClusterServiceServicesRestClient.CreateListNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ConnectedClusterServiceResource(Client, ConnectedClusterServiceData.DeserializeConnectedClusterServiceData(e)), _connectedClusterServiceServicesClientDiagnostics, Pipeline, "ConnectedClusterServiceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/services/{serviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServiceResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="serviceName"> The name of the the service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="serviceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="serviceName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string serviceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(serviceName, nameof(serviceName));

            using var scope = _connectedClusterServiceServicesClientDiagnostics.CreateScope("ConnectedClusterServiceCollection.Exists");
            scope.Start();
            try
            {
                var response = await _connectedClusterServiceServicesRestClient.GetAsync(Id, serviceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/services/{serviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServiceResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="serviceName"> The name of the the service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="serviceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="serviceName"/> is null. </exception>
        public virtual Response<bool> Exists(string serviceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(serviceName, nameof(serviceName));

            using var scope = _connectedClusterServiceServicesClientDiagnostics.CreateScope("ConnectedClusterServiceCollection.Exists");
            scope.Start();
            try
            {
                var response = _connectedClusterServiceServicesRestClient.Get(Id, serviceName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/services/{serviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServiceResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="serviceName"> The name of the the service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="serviceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="serviceName"/> is null. </exception>
        public virtual async Task<NullableResponse<ConnectedClusterServiceResource>> GetIfExistsAsync(string serviceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(serviceName, nameof(serviceName));

            using var scope = _connectedClusterServiceServicesClientDiagnostics.CreateScope("ConnectedClusterServiceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _connectedClusterServiceServicesRestClient.GetAsync(Id, serviceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ConnectedClusterServiceResource>(response.GetRawResponse());
                return Response.FromValue(new ConnectedClusterServiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/services/{serviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServiceResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="serviceName"> The name of the the service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="serviceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="serviceName"/> is null. </exception>
        public virtual NullableResponse<ConnectedClusterServiceResource> GetIfExists(string serviceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(serviceName, nameof(serviceName));

            using var scope = _connectedClusterServiceServicesClientDiagnostics.CreateScope("ConnectedClusterServiceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _connectedClusterServiceServicesRestClient.Get(Id, serviceName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ConnectedClusterServiceResource>(response.GetRawResponse());
                return Response.FromValue(new ConnectedClusterServiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ConnectedClusterServiceResource> IEnumerable<ConnectedClusterServiceResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ConnectedClusterServiceResource> IAsyncEnumerable<ConnectedClusterServiceResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
