// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.ContainerOrchestratorRuntime
{
    /// <summary>
    /// A class representing a collection of <see cref="ConnectedClusterLoadBalancerResource"/> and their operations.
    /// Each <see cref="ConnectedClusterLoadBalancerResource"/> in the collection will belong to the same instance of <see cref="ArmResource"/>.
    /// To get a <see cref="ConnectedClusterLoadBalancerCollection"/> instance call the GetConnectedClusterLoadBalancers method from an instance of <see cref="ArmResource"/>.
    /// </summary>
    public partial class ConnectedClusterLoadBalancerCollection : ArmCollection, IEnumerable<ConnectedClusterLoadBalancerResource>, IAsyncEnumerable<ConnectedClusterLoadBalancerResource>
    {
        private readonly ClientDiagnostics _connectedClusterLoadBalancerLoadBalancersClientDiagnostics;
        private readonly LoadBalancersRestOperations _connectedClusterLoadBalancerLoadBalancersRestClient;

        /// <summary> Initializes a new instance of the <see cref="ConnectedClusterLoadBalancerCollection"/> class for mocking. </summary>
        protected ConnectedClusterLoadBalancerCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ConnectedClusterLoadBalancerCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ConnectedClusterLoadBalancerCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _connectedClusterLoadBalancerLoadBalancersClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ContainerOrchestratorRuntime", ConnectedClusterLoadBalancerResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ConnectedClusterLoadBalancerResource.ResourceType, out string connectedClusterLoadBalancerLoadBalancersApiVersion);
            _connectedClusterLoadBalancerLoadBalancersRestClient = new LoadBalancersRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, connectedClusterLoadBalancerLoadBalancersApiVersion);
        }

        /// <summary>
        /// Create a LoadBalancer
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/loadBalancers/{loadBalancerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LoadBalancer_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterLoadBalancerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="loadBalancerName"> The name of the LoadBalancer. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="loadBalancerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="loadBalancerName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ConnectedClusterLoadBalancerResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string loadBalancerName, ConnectedClusterLoadBalancerData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(loadBalancerName, nameof(loadBalancerName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _connectedClusterLoadBalancerLoadBalancersClientDiagnostics.CreateScope("ConnectedClusterLoadBalancerCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _connectedClusterLoadBalancerLoadBalancersRestClient.CreateOrUpdateAsync(Id, loadBalancerName, data, cancellationToken).ConfigureAwait(false);
                var operation = new ContainerOrchestratorRuntimeArmOperation<ConnectedClusterLoadBalancerResource>(new ConnectedClusterLoadBalancerOperationSource(Client), _connectedClusterLoadBalancerLoadBalancersClientDiagnostics, Pipeline, _connectedClusterLoadBalancerLoadBalancersRestClient.CreateCreateOrUpdateRequest(Id, loadBalancerName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a LoadBalancer
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/loadBalancers/{loadBalancerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LoadBalancer_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterLoadBalancerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="loadBalancerName"> The name of the LoadBalancer. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="loadBalancerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="loadBalancerName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ConnectedClusterLoadBalancerResource> CreateOrUpdate(WaitUntil waitUntil, string loadBalancerName, ConnectedClusterLoadBalancerData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(loadBalancerName, nameof(loadBalancerName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _connectedClusterLoadBalancerLoadBalancersClientDiagnostics.CreateScope("ConnectedClusterLoadBalancerCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _connectedClusterLoadBalancerLoadBalancersRestClient.CreateOrUpdate(Id, loadBalancerName, data, cancellationToken);
                var operation = new ContainerOrchestratorRuntimeArmOperation<ConnectedClusterLoadBalancerResource>(new ConnectedClusterLoadBalancerOperationSource(Client), _connectedClusterLoadBalancerLoadBalancersClientDiagnostics, Pipeline, _connectedClusterLoadBalancerLoadBalancersRestClient.CreateCreateOrUpdateRequest(Id, loadBalancerName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a LoadBalancer
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/loadBalancers/{loadBalancerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LoadBalancer_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterLoadBalancerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="loadBalancerName"> The name of the LoadBalancer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="loadBalancerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="loadBalancerName"/> is null. </exception>
        public virtual async Task<Response<ConnectedClusterLoadBalancerResource>> GetAsync(string loadBalancerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(loadBalancerName, nameof(loadBalancerName));

            using var scope = _connectedClusterLoadBalancerLoadBalancersClientDiagnostics.CreateScope("ConnectedClusterLoadBalancerCollection.Get");
            scope.Start();
            try
            {
                var response = await _connectedClusterLoadBalancerLoadBalancersRestClient.GetAsync(Id, loadBalancerName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ConnectedClusterLoadBalancerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a LoadBalancer
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/loadBalancers/{loadBalancerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LoadBalancer_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterLoadBalancerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="loadBalancerName"> The name of the LoadBalancer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="loadBalancerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="loadBalancerName"/> is null. </exception>
        public virtual Response<ConnectedClusterLoadBalancerResource> Get(string loadBalancerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(loadBalancerName, nameof(loadBalancerName));

            using var scope = _connectedClusterLoadBalancerLoadBalancersClientDiagnostics.CreateScope("ConnectedClusterLoadBalancerCollection.Get");
            scope.Start();
            try
            {
                var response = _connectedClusterLoadBalancerLoadBalancersRestClient.Get(Id, loadBalancerName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ConnectedClusterLoadBalancerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List LoadBalancer resources by parent
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/loadBalancers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LoadBalancer_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterLoadBalancerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ConnectedClusterLoadBalancerResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ConnectedClusterLoadBalancerResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _connectedClusterLoadBalancerLoadBalancersRestClient.CreateListRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _connectedClusterLoadBalancerLoadBalancersRestClient.CreateListNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ConnectedClusterLoadBalancerResource(Client, ConnectedClusterLoadBalancerData.DeserializeConnectedClusterLoadBalancerData(e)), _connectedClusterLoadBalancerLoadBalancersClientDiagnostics, Pipeline, "ConnectedClusterLoadBalancerCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List LoadBalancer resources by parent
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/loadBalancers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LoadBalancer_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterLoadBalancerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ConnectedClusterLoadBalancerResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ConnectedClusterLoadBalancerResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _connectedClusterLoadBalancerLoadBalancersRestClient.CreateListRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _connectedClusterLoadBalancerLoadBalancersRestClient.CreateListNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ConnectedClusterLoadBalancerResource(Client, ConnectedClusterLoadBalancerData.DeserializeConnectedClusterLoadBalancerData(e)), _connectedClusterLoadBalancerLoadBalancersClientDiagnostics, Pipeline, "ConnectedClusterLoadBalancerCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/loadBalancers/{loadBalancerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LoadBalancer_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterLoadBalancerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="loadBalancerName"> The name of the LoadBalancer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="loadBalancerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="loadBalancerName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string loadBalancerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(loadBalancerName, nameof(loadBalancerName));

            using var scope = _connectedClusterLoadBalancerLoadBalancersClientDiagnostics.CreateScope("ConnectedClusterLoadBalancerCollection.Exists");
            scope.Start();
            try
            {
                var response = await _connectedClusterLoadBalancerLoadBalancersRestClient.GetAsync(Id, loadBalancerName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/loadBalancers/{loadBalancerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LoadBalancer_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterLoadBalancerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="loadBalancerName"> The name of the LoadBalancer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="loadBalancerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="loadBalancerName"/> is null. </exception>
        public virtual Response<bool> Exists(string loadBalancerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(loadBalancerName, nameof(loadBalancerName));

            using var scope = _connectedClusterLoadBalancerLoadBalancersClientDiagnostics.CreateScope("ConnectedClusterLoadBalancerCollection.Exists");
            scope.Start();
            try
            {
                var response = _connectedClusterLoadBalancerLoadBalancersRestClient.Get(Id, loadBalancerName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/loadBalancers/{loadBalancerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LoadBalancer_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterLoadBalancerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="loadBalancerName"> The name of the LoadBalancer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="loadBalancerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="loadBalancerName"/> is null. </exception>
        public virtual async Task<NullableResponse<ConnectedClusterLoadBalancerResource>> GetIfExistsAsync(string loadBalancerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(loadBalancerName, nameof(loadBalancerName));

            using var scope = _connectedClusterLoadBalancerLoadBalancersClientDiagnostics.CreateScope("ConnectedClusterLoadBalancerCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _connectedClusterLoadBalancerLoadBalancersRestClient.GetAsync(Id, loadBalancerName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ConnectedClusterLoadBalancerResource>(response.GetRawResponse());
                return Response.FromValue(new ConnectedClusterLoadBalancerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/loadBalancers/{loadBalancerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LoadBalancer_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterLoadBalancerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="loadBalancerName"> The name of the LoadBalancer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="loadBalancerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="loadBalancerName"/> is null. </exception>
        public virtual NullableResponse<ConnectedClusterLoadBalancerResource> GetIfExists(string loadBalancerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(loadBalancerName, nameof(loadBalancerName));

            using var scope = _connectedClusterLoadBalancerLoadBalancersClientDiagnostics.CreateScope("ConnectedClusterLoadBalancerCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _connectedClusterLoadBalancerLoadBalancersRestClient.Get(Id, loadBalancerName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ConnectedClusterLoadBalancerResource>(response.GetRawResponse());
                return Response.FromValue(new ConnectedClusterLoadBalancerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ConnectedClusterLoadBalancerResource> IEnumerable<ConnectedClusterLoadBalancerResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ConnectedClusterLoadBalancerResource> IAsyncEnumerable<ConnectedClusterLoadBalancerResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
