// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.ContainerOrchestratorRuntime
{
    /// <summary>
    /// A class representing a collection of <see cref="ConnectedClusterBgpPeerResource"/> and their operations.
    /// Each <see cref="ConnectedClusterBgpPeerResource"/> in the collection will belong to the same instance of <see cref="ArmResource"/>.
    /// To get a <see cref="ConnectedClusterBgpPeerCollection"/> instance call the GetConnectedClusterBgpPeers method from an instance of <see cref="ArmResource"/>.
    /// </summary>
    public partial class ConnectedClusterBgpPeerCollection : ArmCollection, IEnumerable<ConnectedClusterBgpPeerResource>, IAsyncEnumerable<ConnectedClusterBgpPeerResource>
    {
        private readonly ClientDiagnostics _connectedClusterBgpPeerBgpPeersClientDiagnostics;
        private readonly BgpPeersRestOperations _connectedClusterBgpPeerBgpPeersRestClient;

        /// <summary> Initializes a new instance of the <see cref="ConnectedClusterBgpPeerCollection"/> class for mocking. </summary>
        protected ConnectedClusterBgpPeerCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ConnectedClusterBgpPeerCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ConnectedClusterBgpPeerCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _connectedClusterBgpPeerBgpPeersClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ContainerOrchestratorRuntime", ConnectedClusterBgpPeerResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ConnectedClusterBgpPeerResource.ResourceType, out string connectedClusterBgpPeerBgpPeersApiVersion);
            _connectedClusterBgpPeerBgpPeersRestClient = new BgpPeersRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, connectedClusterBgpPeerBgpPeersApiVersion);
        }

        /// <summary>
        /// Create a BgpPeer
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/bgpPeers/{bgpPeerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BgpPeer_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterBgpPeerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="bgpPeerName"> The name of the BgpPeer. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="bgpPeerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="bgpPeerName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ConnectedClusterBgpPeerResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string bgpPeerName, ConnectedClusterBgpPeerData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(bgpPeerName, nameof(bgpPeerName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _connectedClusterBgpPeerBgpPeersClientDiagnostics.CreateScope("ConnectedClusterBgpPeerCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _connectedClusterBgpPeerBgpPeersRestClient.CreateOrUpdateAsync(Id, bgpPeerName, data, cancellationToken).ConfigureAwait(false);
                var operation = new ContainerOrchestratorRuntimeArmOperation<ConnectedClusterBgpPeerResource>(new ConnectedClusterBgpPeerOperationSource(Client), _connectedClusterBgpPeerBgpPeersClientDiagnostics, Pipeline, _connectedClusterBgpPeerBgpPeersRestClient.CreateCreateOrUpdateRequest(Id, bgpPeerName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a BgpPeer
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/bgpPeers/{bgpPeerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BgpPeer_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterBgpPeerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="bgpPeerName"> The name of the BgpPeer. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="bgpPeerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="bgpPeerName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ConnectedClusterBgpPeerResource> CreateOrUpdate(WaitUntil waitUntil, string bgpPeerName, ConnectedClusterBgpPeerData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(bgpPeerName, nameof(bgpPeerName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _connectedClusterBgpPeerBgpPeersClientDiagnostics.CreateScope("ConnectedClusterBgpPeerCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _connectedClusterBgpPeerBgpPeersRestClient.CreateOrUpdate(Id, bgpPeerName, data, cancellationToken);
                var operation = new ContainerOrchestratorRuntimeArmOperation<ConnectedClusterBgpPeerResource>(new ConnectedClusterBgpPeerOperationSource(Client), _connectedClusterBgpPeerBgpPeersClientDiagnostics, Pipeline, _connectedClusterBgpPeerBgpPeersRestClient.CreateCreateOrUpdateRequest(Id, bgpPeerName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a BgpPeer
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/bgpPeers/{bgpPeerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BgpPeer_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterBgpPeerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="bgpPeerName"> The name of the BgpPeer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="bgpPeerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="bgpPeerName"/> is null. </exception>
        public virtual async Task<Response<ConnectedClusterBgpPeerResource>> GetAsync(string bgpPeerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(bgpPeerName, nameof(bgpPeerName));

            using var scope = _connectedClusterBgpPeerBgpPeersClientDiagnostics.CreateScope("ConnectedClusterBgpPeerCollection.Get");
            scope.Start();
            try
            {
                var response = await _connectedClusterBgpPeerBgpPeersRestClient.GetAsync(Id, bgpPeerName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ConnectedClusterBgpPeerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a BgpPeer
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/bgpPeers/{bgpPeerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BgpPeer_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterBgpPeerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="bgpPeerName"> The name of the BgpPeer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="bgpPeerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="bgpPeerName"/> is null. </exception>
        public virtual Response<ConnectedClusterBgpPeerResource> Get(string bgpPeerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(bgpPeerName, nameof(bgpPeerName));

            using var scope = _connectedClusterBgpPeerBgpPeersClientDiagnostics.CreateScope("ConnectedClusterBgpPeerCollection.Get");
            scope.Start();
            try
            {
                var response = _connectedClusterBgpPeerBgpPeersRestClient.Get(Id, bgpPeerName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ConnectedClusterBgpPeerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List BgpPeer resources by parent
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/bgpPeers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BgpPeer_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterBgpPeerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ConnectedClusterBgpPeerResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ConnectedClusterBgpPeerResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _connectedClusterBgpPeerBgpPeersRestClient.CreateListRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _connectedClusterBgpPeerBgpPeersRestClient.CreateListNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ConnectedClusterBgpPeerResource(Client, ConnectedClusterBgpPeerData.DeserializeConnectedClusterBgpPeerData(e)), _connectedClusterBgpPeerBgpPeersClientDiagnostics, Pipeline, "ConnectedClusterBgpPeerCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List BgpPeer resources by parent
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/bgpPeers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BgpPeer_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterBgpPeerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ConnectedClusterBgpPeerResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ConnectedClusterBgpPeerResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _connectedClusterBgpPeerBgpPeersRestClient.CreateListRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _connectedClusterBgpPeerBgpPeersRestClient.CreateListNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ConnectedClusterBgpPeerResource(Client, ConnectedClusterBgpPeerData.DeserializeConnectedClusterBgpPeerData(e)), _connectedClusterBgpPeerBgpPeersClientDiagnostics, Pipeline, "ConnectedClusterBgpPeerCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/bgpPeers/{bgpPeerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BgpPeer_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterBgpPeerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="bgpPeerName"> The name of the BgpPeer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="bgpPeerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="bgpPeerName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string bgpPeerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(bgpPeerName, nameof(bgpPeerName));

            using var scope = _connectedClusterBgpPeerBgpPeersClientDiagnostics.CreateScope("ConnectedClusterBgpPeerCollection.Exists");
            scope.Start();
            try
            {
                var response = await _connectedClusterBgpPeerBgpPeersRestClient.GetAsync(Id, bgpPeerName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/bgpPeers/{bgpPeerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BgpPeer_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterBgpPeerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="bgpPeerName"> The name of the BgpPeer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="bgpPeerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="bgpPeerName"/> is null. </exception>
        public virtual Response<bool> Exists(string bgpPeerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(bgpPeerName, nameof(bgpPeerName));

            using var scope = _connectedClusterBgpPeerBgpPeersClientDiagnostics.CreateScope("ConnectedClusterBgpPeerCollection.Exists");
            scope.Start();
            try
            {
                var response = _connectedClusterBgpPeerBgpPeersRestClient.Get(Id, bgpPeerName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/bgpPeers/{bgpPeerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BgpPeer_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterBgpPeerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="bgpPeerName"> The name of the BgpPeer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="bgpPeerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="bgpPeerName"/> is null. </exception>
        public virtual async Task<NullableResponse<ConnectedClusterBgpPeerResource>> GetIfExistsAsync(string bgpPeerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(bgpPeerName, nameof(bgpPeerName));

            using var scope = _connectedClusterBgpPeerBgpPeersClientDiagnostics.CreateScope("ConnectedClusterBgpPeerCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _connectedClusterBgpPeerBgpPeersRestClient.GetAsync(Id, bgpPeerName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ConnectedClusterBgpPeerResource>(response.GetRawResponse());
                return Response.FromValue(new ConnectedClusterBgpPeerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.KubernetesRuntime/bgpPeers/{bgpPeerName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BgpPeer_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectedClusterBgpPeerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="bgpPeerName"> The name of the BgpPeer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="bgpPeerName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="bgpPeerName"/> is null. </exception>
        public virtual NullableResponse<ConnectedClusterBgpPeerResource> GetIfExists(string bgpPeerName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(bgpPeerName, nameof(bgpPeerName));

            using var scope = _connectedClusterBgpPeerBgpPeersClientDiagnostics.CreateScope("ConnectedClusterBgpPeerCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _connectedClusterBgpPeerBgpPeersRestClient.Get(Id, bgpPeerName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ConnectedClusterBgpPeerResource>(response.GetRawResponse());
                return Response.FromValue(new ConnectedClusterBgpPeerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ConnectedClusterBgpPeerResource> IEnumerable<ConnectedClusterBgpPeerResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ConnectedClusterBgpPeerResource> IAsyncEnumerable<ConnectedClusterBgpPeerResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
