// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ContainerOrchestratorRuntime.Models;

namespace Azure.ResourceManager.ContainerOrchestratorRuntime.Samples
{
    public partial class Sample_ConnectedClusterServiceResource
    {
        // Services_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ServicesGet()
        {
            // Generated from example definition: 2024-03-01/Services_Get.json
            // this example is just showing the usage of "ServiceResource_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConnectedClusterServiceResource created on azure
            // for more information of creating ConnectedClusterServiceResource, please refer to the document of ConnectedClusterServiceResource
            string resourceUri = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1";
            string serviceName = "storageclass";
            ResourceIdentifier connectedClusterServiceResourceId = ConnectedClusterServiceResource.CreateResourceIdentifier(resourceUri, serviceName);
            ConnectedClusterServiceResource connectedClusterService = client.GetConnectedClusterServiceResource(connectedClusterServiceResourceId);

            // invoke the operation
            ConnectedClusterServiceResource result = await connectedClusterService.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ConnectedClusterServiceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Services_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ServicesCreateOrUpdate()
        {
            // Generated from example definition: 2024-03-01/Services_CreateOrUpdate.json
            // this example is just showing the usage of "ServiceResource_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConnectedClusterServiceResource created on azure
            // for more information of creating ConnectedClusterServiceResource, please refer to the document of ConnectedClusterServiceResource
            string resourceUri = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1";
            string serviceName = "storageclass";
            ResourceIdentifier connectedClusterServiceResourceId = ConnectedClusterServiceResource.CreateResourceIdentifier(resourceUri, serviceName);
            ConnectedClusterServiceResource connectedClusterService = client.GetConnectedClusterServiceResource(connectedClusterServiceResourceId);

            // invoke the operation
            ConnectedClusterServiceData data = new ConnectedClusterServiceData()
            {
                Properties = new ConnectedClusterServiceProperties(),
            };
            ArmOperation<ConnectedClusterServiceResource> lro = await connectedClusterService.UpdateAsync(WaitUntil.Completed, data);
            ConnectedClusterServiceResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ConnectedClusterServiceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Services_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ServicesDelete()
        {
            // Generated from example definition: 2024-03-01/Services_Delete.json
            // this example is just showing the usage of "ServiceResource_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConnectedClusterServiceResource created on azure
            // for more information of creating ConnectedClusterServiceResource, please refer to the document of ConnectedClusterServiceResource
            string resourceUri = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1";
            string serviceName = "storageclass";
            ResourceIdentifier connectedClusterServiceResourceId = ConnectedClusterServiceResource.CreateResourceIdentifier(resourceUri, serviceName);
            ConnectedClusterServiceResource connectedClusterService = client.GetConnectedClusterServiceResource(connectedClusterServiceResourceId);

            // invoke the operation
            await connectedClusterService.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
