// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerInstance.Models
{
    /// <summary> The init container definition. </summary>
    public partial class InitContainerDefinitionContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InitContainerDefinitionContent"/>. </summary>
        /// <param name="name"> The name for the init container. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public InitContainerDefinitionContent(string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            Name = name;
            Command = new ChangeTrackingList<string>();
            EnvironmentVariables = new ChangeTrackingList<ContainerEnvironmentVariable>();
            VolumeMounts = new ChangeTrackingList<ContainerVolumeMount>();
        }

        /// <summary> Initializes a new instance of <see cref="InitContainerDefinitionContent"/>. </summary>
        /// <param name="name"> The name for the init container. </param>
        /// <param name="image"> The image of the init container. </param>
        /// <param name="command"> The command to execute within the init container in exec form. </param>
        /// <param name="environmentVariables"> The environment variables to set in the init container. </param>
        /// <param name="instanceView"> The instance view of the init container. Only valid in response. </param>
        /// <param name="volumeMounts"> The volume mounts available to the init container. </param>
        /// <param name="securityContext"> The container security properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InitContainerDefinitionContent(string name, string image, IList<string> command, IList<ContainerEnvironmentVariable> environmentVariables, InitContainerPropertiesDefinitionInstanceView instanceView, IList<ContainerVolumeMount> volumeMounts, ContainerSecurityContextDefinition securityContext, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Image = image;
            Command = command;
            EnvironmentVariables = environmentVariables;
            InstanceView = instanceView;
            VolumeMounts = volumeMounts;
            SecurityContext = securityContext;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="InitContainerDefinitionContent"/> for deserialization. </summary>
        internal InitContainerDefinitionContent()
        {
        }

        /// <summary> The name for the init container. </summary>
        public string Name { get; set; }
        /// <summary> The image of the init container. </summary>
        public string Image { get; set; }
        /// <summary> The command to execute within the init container in exec form. </summary>
        public IList<string> Command { get; }
        /// <summary> The environment variables to set in the init container. </summary>
        public IList<ContainerEnvironmentVariable> EnvironmentVariables { get; }
        /// <summary> The instance view of the init container. Only valid in response. </summary>
        public InitContainerPropertiesDefinitionInstanceView InstanceView { get; }
        /// <summary> The volume mounts available to the init container. </summary>
        public IList<ContainerVolumeMount> VolumeMounts { get; }
        /// <summary> The container security properties. </summary>
        public ContainerSecurityContextDefinition SecurityContext { get; set; }
    }
}
