// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ContainerInstance.Models
{
    public partial class ContainerSupportedCapabilities : IUtf8JsonSerializable, IJsonModel<ContainerSupportedCapabilities>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ContainerSupportedCapabilities>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ContainerSupportedCapabilities>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerSupportedCapabilities>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerSupportedCapabilities)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(MaxMemoryInGB))
            {
                writer.WritePropertyName("maxMemoryInGB"u8);
                writer.WriteNumberValue(MaxMemoryInGB.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MaxCpu))
            {
                writer.WritePropertyName("maxCpu"u8);
                writer.WriteNumberValue(MaxCpu.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MaxGpuCount))
            {
                writer.WritePropertyName("maxGpuCount"u8);
                writer.WriteNumberValue(MaxGpuCount.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ContainerSupportedCapabilities IJsonModel<ContainerSupportedCapabilities>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerSupportedCapabilities>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerSupportedCapabilities)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeContainerSupportedCapabilities(document.RootElement, options);
        }

        internal static ContainerSupportedCapabilities DeserializeContainerSupportedCapabilities(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            float? maxMemoryInGB = default;
            float? maxCpu = default;
            float? maxGpuCount = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("maxMemoryInGB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxMemoryInGB = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("maxCpu"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxCpu = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("maxGpuCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxGpuCount = property.Value.GetSingle();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ContainerSupportedCapabilities(maxMemoryInGB, maxCpu, maxGpuCount, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ContainerSupportedCapabilities>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerSupportedCapabilities>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ContainerSupportedCapabilities)} does not support writing '{options.Format}' format.");
            }
        }

        ContainerSupportedCapabilities IPersistableModel<ContainerSupportedCapabilities>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerSupportedCapabilities>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeContainerSupportedCapabilities(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ContainerSupportedCapabilities)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ContainerSupportedCapabilities>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
