// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerInstance.Models
{
    /// <summary> The resource requirements. </summary>
    public partial class ContainerResourceRequirements
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerResourceRequirements"/>. </summary>
        /// <param name="requests"> The resource requests of this container instance. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="requests"/> is null. </exception>
        public ContainerResourceRequirements(ContainerResourceRequestsContent requests)
        {
            Argument.AssertNotNull(requests, nameof(requests));

            Requests = requests;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerResourceRequirements"/>. </summary>
        /// <param name="requests"> The resource requests of this container instance. </param>
        /// <param name="limits"> The resource limits of this container instance. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerResourceRequirements(ContainerResourceRequestsContent requests, ContainerResourceLimits limits, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Requests = requests;
            Limits = limits;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerResourceRequirements"/> for deserialization. </summary>
        internal ContainerResourceRequirements()
        {
        }

        /// <summary> The resource requests of this container instance. </summary>
        public ContainerResourceRequestsContent Requests { get; set; }
        /// <summary> The resource limits of this container instance. </summary>
        public ContainerResourceLimits Limits { get; set; }
    }
}
