// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerInstance.Models
{
    /// <summary> The resource requests. </summary>
    public partial class ContainerResourceRequestsContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerResourceRequestsContent"/>. </summary>
        /// <param name="memoryInGB"> The memory request in GB of this container instance. </param>
        /// <param name="cpu"> The CPU request of this container instance. </param>
        public ContainerResourceRequestsContent(double memoryInGB, double cpu)
        {
            MemoryInGB = memoryInGB;
            Cpu = cpu;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerResourceRequestsContent"/>. </summary>
        /// <param name="memoryInGB"> The memory request in GB of this container instance. </param>
        /// <param name="cpu"> The CPU request of this container instance. </param>
        /// <param name="gpu"> The GPU request of this container instance. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerResourceRequestsContent(double memoryInGB, double cpu, ContainerGpuResourceInfo gpu, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MemoryInGB = memoryInGB;
            Cpu = cpu;
            Gpu = gpu;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerResourceRequestsContent"/> for deserialization. </summary>
        internal ContainerResourceRequestsContent()
        {
        }

        /// <summary> The memory request in GB of this container instance. </summary>
        public double MemoryInGB { get; set; }
        /// <summary> The CPU request of this container instance. </summary>
        public double Cpu { get; set; }
        /// <summary> The GPU request of this container instance. </summary>
        public ContainerGpuResourceInfo Gpu { get; set; }
    }
}
