// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerInstance.Models
{
    /// <summary> Represents a volume that is populated with the contents of a git repository. </summary>
    public partial class ContainerInstanceGitRepoVolume
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerInstanceGitRepoVolume"/>. </summary>
        /// <param name="repository"> Repository URL. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="repository"/> is null. </exception>
        public ContainerInstanceGitRepoVolume(string repository)
        {
            Argument.AssertNotNull(repository, nameof(repository));

            Repository = repository;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerInstanceGitRepoVolume"/>. </summary>
        /// <param name="directory"> Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name. </param>
        /// <param name="repository"> Repository URL. </param>
        /// <param name="revision"> Commit hash for the specified revision. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerInstanceGitRepoVolume(string directory, string repository, string revision, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Directory = directory;
            Repository = repository;
            Revision = revision;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerInstanceGitRepoVolume"/> for deserialization. </summary>
        internal ContainerInstanceGitRepoVolume()
        {
        }

        /// <summary> Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name. </summary>
        public string Directory { get; set; }
        /// <summary> Repository URL. </summary>
        public string Repository { get; set; }
        /// <summary> Commit hash for the specified revision. </summary>
        public string Revision { get; set; }
    }
}
