// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerInstance.Models
{
    /// <summary> The scheme. </summary>
    public readonly partial struct ContainerHttpGetScheme : IEquatable<ContainerHttpGetScheme>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerHttpGetScheme"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerHttpGetScheme(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HttpValue = "http";
        private const string HttpsValue = "https";

        /// <summary> http. </summary>
        public static ContainerHttpGetScheme Http { get; } = new ContainerHttpGetScheme(HttpValue);
        /// <summary> https. </summary>
        public static ContainerHttpGetScheme Https { get; } = new ContainerHttpGetScheme(HttpsValue);
        /// <summary> Determines if two <see cref="ContainerHttpGetScheme"/> values are the same. </summary>
        public static bool operator ==(ContainerHttpGetScheme left, ContainerHttpGetScheme right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerHttpGetScheme"/> values are not the same. </summary>
        public static bool operator !=(ContainerHttpGetScheme left, ContainerHttpGetScheme right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerHttpGetScheme"/>. </summary>
        public static implicit operator ContainerHttpGetScheme(string value) => new ContainerHttpGetScheme(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerHttpGetScheme other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerHttpGetScheme other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
