// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerInstance.Models
{
    /// <summary>
    /// Restart policy for all containers within the container group.
    /// - `Always` Always restart
    /// - `OnFailure` Restart on failure
    /// - `Never` Never restart
    ///
    /// </summary>
    public readonly partial struct ContainerGroupRestartPolicy : IEquatable<ContainerGroupRestartPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerGroupRestartPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerGroupRestartPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AlwaysValue = "Always";
        private const string OnFailureValue = "OnFailure";
        private const string NeverValue = "Never";

        /// <summary> Always. </summary>
        public static ContainerGroupRestartPolicy Always { get; } = new ContainerGroupRestartPolicy(AlwaysValue);
        /// <summary> OnFailure. </summary>
        public static ContainerGroupRestartPolicy OnFailure { get; } = new ContainerGroupRestartPolicy(OnFailureValue);
        /// <summary> Never. </summary>
        public static ContainerGroupRestartPolicy Never { get; } = new ContainerGroupRestartPolicy(NeverValue);
        /// <summary> Determines if two <see cref="ContainerGroupRestartPolicy"/> values are the same. </summary>
        public static bool operator ==(ContainerGroupRestartPolicy left, ContainerGroupRestartPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerGroupRestartPolicy"/> values are not the same. </summary>
        public static bool operator !=(ContainerGroupRestartPolicy left, ContainerGroupRestartPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerGroupRestartPolicy"/>. </summary>
        public static implicit operator ContainerGroupRestartPolicy(string value) => new ContainerGroupRestartPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerGroupRestartPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerGroupRestartPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
