// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerInstance.Models
{
    /// <summary> The protocol associated with the port. </summary>
    public readonly partial struct ContainerGroupNetworkProtocol : IEquatable<ContainerGroupNetworkProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerGroupNetworkProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerGroupNetworkProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TcpValue = "TCP";
        private const string UdpValue = "UDP";

        /// <summary> TCP. </summary>
        public static ContainerGroupNetworkProtocol Tcp { get; } = new ContainerGroupNetworkProtocol(TcpValue);
        /// <summary> UDP. </summary>
        public static ContainerGroupNetworkProtocol Udp { get; } = new ContainerGroupNetworkProtocol(UdpValue);
        /// <summary> Determines if two <see cref="ContainerGroupNetworkProtocol"/> values are the same. </summary>
        public static bool operator ==(ContainerGroupNetworkProtocol left, ContainerGroupNetworkProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerGroupNetworkProtocol"/> values are not the same. </summary>
        public static bool operator !=(ContainerGroupNetworkProtocol left, ContainerGroupNetworkProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerGroupNetworkProtocol"/>. </summary>
        public static implicit operator ContainerGroupNetworkProtocol(string value) => new ContainerGroupNetworkProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerGroupNetworkProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerGroupNetworkProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
