// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerInstance.Models
{
    /// <summary> Image registry credential. </summary>
    public partial class ContainerGroupImageRegistryCredential
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerGroupImageRegistryCredential"/>. </summary>
        /// <param name="server"> The Docker image registry server without a protocol such as "http" and "https". </param>
        /// <exception cref="ArgumentNullException"> <paramref name="server"/> is null. </exception>
        public ContainerGroupImageRegistryCredential(string server)
        {
            Argument.AssertNotNull(server, nameof(server));

            Server = server;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerGroupImageRegistryCredential"/>. </summary>
        /// <param name="server"> The Docker image registry server without a protocol such as "http" and "https". </param>
        /// <param name="username"> The username for the private registry. </param>
        /// <param name="password"> The password for the private registry. </param>
        /// <param name="identity"> The identity for the private registry. </param>
        /// <param name="identityUri"> The identity URL for the private registry. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerGroupImageRegistryCredential(string server, string username, string password, string identity, Uri identityUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Server = server;
            Username = username;
            Password = password;
            Identity = identity;
            IdentityUri = identityUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerGroupImageRegistryCredential"/> for deserialization. </summary>
        internal ContainerGroupImageRegistryCredential()
        {
        }

        /// <summary> The Docker image registry server without a protocol such as "http" and "https". </summary>
        public string Server { get; set; }
        /// <summary> The username for the private registry. </summary>
        public string Username { get; set; }
        /// <summary> The password for the private registry. </summary>
        public string Password { get; set; }
        /// <summary> The identity for the private registry. </summary>
        public string Identity { get; set; }
        /// <summary> The identity URL for the private registry. </summary>
        public Uri IdentityUri { get; set; }
    }
}
