// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerInstance.Models
{
    /// <summary> Specifies if the IP is exposed to the public internet or private VNET. </summary>
    public readonly partial struct ContainerGroupIPAddressType : IEquatable<ContainerGroupIPAddressType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerGroupIPAddressType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerGroupIPAddressType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PublicValue = "Public";
        private const string PrivateValue = "Private";

        /// <summary> Public. </summary>
        public static ContainerGroupIPAddressType Public { get; } = new ContainerGroupIPAddressType(PublicValue);
        /// <summary> Private. </summary>
        public static ContainerGroupIPAddressType Private { get; } = new ContainerGroupIPAddressType(PrivateValue);
        /// <summary> Determines if two <see cref="ContainerGroupIPAddressType"/> values are the same. </summary>
        public static bool operator ==(ContainerGroupIPAddressType left, ContainerGroupIPAddressType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerGroupIPAddressType"/> values are not the same. </summary>
        public static bool operator !=(ContainerGroupIPAddressType left, ContainerGroupIPAddressType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerGroupIPAddressType"/>. </summary>
        public static implicit operator ContainerGroupIPAddressType(string value) => new ContainerGroupIPAddressType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerGroupIPAddressType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerGroupIPAddressType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
