// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ContainerInstance.Models
{
    /// <summary> The regional capabilities. </summary>
    public partial class ContainerCapabilities
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerCapabilities"/>. </summary>
        internal ContainerCapabilities()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerCapabilities"/>. </summary>
        /// <param name="resourceType"> The resource type that this capability describes. </param>
        /// <param name="osType"> The OS type that this capability describes. </param>
        /// <param name="location"> The resource location. </param>
        /// <param name="ipAddressType"> The ip address type that this capability describes. </param>
        /// <param name="gpu"> The GPU sku that this capability describes. </param>
        /// <param name="capabilities"> The supported capabilities. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerCapabilities(string resourceType, string osType, AzureLocation? location, string ipAddressType, string gpu, ContainerSupportedCapabilities capabilities, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceType = resourceType;
            OSType = osType;
            Location = location;
            IPAddressType = ipAddressType;
            Gpu = gpu;
            Capabilities = capabilities;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The resource type that this capability describes. </summary>
        public string ResourceType { get; }
        /// <summary> The OS type that this capability describes. </summary>
        public string OSType { get; }
        /// <summary> The resource location. </summary>
        public AzureLocation? Location { get; }
        /// <summary> The ip address type that this capability describes. </summary>
        public string IPAddressType { get; }
        /// <summary> The GPU sku that this capability describes. </summary>
        public string Gpu { get; }
        /// <summary> The supported capabilities. </summary>
        public ContainerSupportedCapabilities Capabilities { get; }
    }
}
