// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ContainerInstance
{
    internal class ContainerGroupOperationSource : IOperationSource<ContainerGroupResource>
    {
        private readonly ArmClient _client;

        internal ContainerGroupOperationSource(ArmClient client)
        {
            _client = client;
        }

        ContainerGroupResource IOperationSource<ContainerGroupResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ContainerGroupData.DeserializeContainerGroupData(document.RootElement);
            return new ContainerGroupResource(_client, data);
        }

        async ValueTask<ContainerGroupResource> IOperationSource<ContainerGroupResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ContainerGroupData.DeserializeContainerGroupData(document.RootElement);
            return new ContainerGroupResource(_client, data);
        }
    }
}
