// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.ContainerInstance.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ContainerInstance
{
    /// <summary>
    /// A class representing the ContainerGroupProfile data model.
    /// A container group profile.
    /// </summary>
    public partial class ContainerGroupProfileData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerGroupProfileData"/>. </summary>
        /// <param name="location"> The location. </param>
        /// <param name="containers"> The containers within the container group. </param>
        /// <param name="osType"> The operating system type required by the containers in the container group. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="containers"/> is null. </exception>
        public ContainerGroupProfileData(AzureLocation location, IEnumerable<ContainerInstanceContainer> containers, ContainerInstanceOperatingSystemType osType) : base(location)
        {
            Argument.AssertNotNull(containers, nameof(containers));

            Containers = containers.ToList();
            ImageRegistryCredentials = new ChangeTrackingList<ContainerGroupImageRegistryCredential>();
            OSType = osType;
            Volumes = new ChangeTrackingList<ContainerVolume>();
            InitContainers = new ChangeTrackingList<InitContainerDefinitionContent>();
            Extensions = new ChangeTrackingList<DeploymentExtensionSpec>();
            Zones = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ContainerGroupProfileData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="containers"> The containers within the container group. </param>
        /// <param name="imageRegistryCredentials"> The image registry credentials by which the container group is created from. </param>
        /// <param name="restartPolicy">
        /// Restart policy for all containers within the container group.
        /// - `Always` Always restart
        /// - `OnFailure` Restart on failure
        /// - `Never` Never restart
        ///
        /// </param>
        /// <param name="ipAddress"> The IP address type of the container group. </param>
        /// <param name="osType"> The operating system type required by the containers in the container group. </param>
        /// <param name="volumes"> The list of volumes that can be mounted by containers in this container group. </param>
        /// <param name="diagnostics"> The diagnostic information for a container group. </param>
        /// <param name="sku"> The SKU for a container group. </param>
        /// <param name="encryptionProperties"> The encryption properties for a container group. </param>
        /// <param name="initContainers"> The init containers for a container group. </param>
        /// <param name="extensions"> extensions used by virtual kubelet. </param>
        /// <param name="confidentialComputeProperties"> The properties for confidential container group. </param>
        /// <param name="priority"> The priority of the container group. </param>
        /// <param name="revision"> The container group profile current revision number. This only appears in the response. </param>
        /// <param name="zones"> The zones for the container group. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerGroupProfileData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, IList<ContainerInstanceContainer> containers, IList<ContainerGroupImageRegistryCredential> imageRegistryCredentials, ContainerGroupRestartPolicy? restartPolicy, ContainerGroupIPAddress ipAddress, ContainerInstanceOperatingSystemType osType, IList<ContainerVolume> volumes, ContainerGroupDiagnostics diagnostics, ContainerGroupSku? sku, ContainerGroupEncryptionProperties encryptionProperties, IList<InitContainerDefinitionContent> initContainers, IList<DeploymentExtensionSpec> extensions, ConfidentialComputeProperties confidentialComputeProperties, ContainerGroupPriority? priority, int? revision, IList<string> zones, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Containers = containers;
            ImageRegistryCredentials = imageRegistryCredentials;
            RestartPolicy = restartPolicy;
            IPAddress = ipAddress;
            OSType = osType;
            Volumes = volumes;
            Diagnostics = diagnostics;
            Sku = sku;
            EncryptionProperties = encryptionProperties;
            InitContainers = initContainers;
            Extensions = extensions;
            ConfidentialComputeProperties = confidentialComputeProperties;
            Priority = priority;
            Revision = revision;
            Zones = zones;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerGroupProfileData"/> for deserialization. </summary>
        internal ContainerGroupProfileData()
        {
        }

        /// <summary> The containers within the container group. </summary>
        public IList<ContainerInstanceContainer> Containers { get; }
        /// <summary> The image registry credentials by which the container group is created from. </summary>
        public IList<ContainerGroupImageRegistryCredential> ImageRegistryCredentials { get; }
        /// <summary>
        /// Restart policy for all containers within the container group.
        /// - `Always` Always restart
        /// - `OnFailure` Restart on failure
        /// - `Never` Never restart
        ///
        /// </summary>
        public ContainerGroupRestartPolicy? RestartPolicy { get; set; }
        /// <summary> The IP address type of the container group. </summary>
        public ContainerGroupIPAddress IPAddress { get; set; }
        /// <summary> The operating system type required by the containers in the container group. </summary>
        public ContainerInstanceOperatingSystemType OSType { get; set; }
        /// <summary> The list of volumes that can be mounted by containers in this container group. </summary>
        public IList<ContainerVolume> Volumes { get; }
        /// <summary> The diagnostic information for a container group. </summary>
        internal ContainerGroupDiagnostics Diagnostics { get; set; }
        /// <summary> Container group log analytics information. </summary>
        public ContainerGroupLogAnalytics DiagnosticsLogAnalytics
        {
            get => Diagnostics is null ? default : Diagnostics.LogAnalytics;
            set
            {
                if (Diagnostics is null)
                    Diagnostics = new ContainerGroupDiagnostics();
                Diagnostics.LogAnalytics = value;
            }
        }

        /// <summary> The SKU for a container group. </summary>
        public ContainerGroupSku? Sku { get; set; }
        /// <summary> The encryption properties for a container group. </summary>
        public ContainerGroupEncryptionProperties EncryptionProperties { get; set; }
        /// <summary> The init containers for a container group. </summary>
        public IList<InitContainerDefinitionContent> InitContainers { get; }
        /// <summary> extensions used by virtual kubelet. </summary>
        public IList<DeploymentExtensionSpec> Extensions { get; }
        /// <summary> The properties for confidential container group. </summary>
        internal ConfidentialComputeProperties ConfidentialComputeProperties { get; set; }
        /// <summary> The base64 encoded confidential compute enforcement policy. </summary>
        public string ConfidentialComputeCcePolicy
        {
            get => ConfidentialComputeProperties is null ? default : ConfidentialComputeProperties.CcePolicy;
            set
            {
                if (ConfidentialComputeProperties is null)
                    ConfidentialComputeProperties = new ConfidentialComputeProperties();
                ConfidentialComputeProperties.CcePolicy = value;
            }
        }

        /// <summary> The priority of the container group. </summary>
        public ContainerGroupPriority? Priority { get; set; }
        /// <summary> The container group profile current revision number. This only appears in the response. </summary>
        public int? Revision { get; }
        /// <summary> The zones for the container group. </summary>
        public IList<string> Zones { get; }
    }
}
