// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerInstance.Models
{
    /// <summary> IP address for the container group. </summary>
    public partial class ContainerGroupIPAddress
    {
        /// <summary> The value representing the security enum. </summary>
        [Obsolete("DnsNameLabelReusePolicy is deprecated, use AutoGeneratedDnsNameLabelScope instead", false)]
        [EditorBrowsable(EditorBrowsableState.Never)]
        public AutoGeneratedDomainNameLabelScope? DnsNameLabelReusePolicy
        {
            get => AutoGeneratedDomainNameLabelScope == null ? null : new AutoGeneratedDomainNameLabelScope(AutoGeneratedDomainNameLabelScope.Value.ToString());
            set
            {
                AutoGeneratedDomainNameLabelScope = value == null ? null : new DnsNameLabelReusePolicy(value.Value.ToString());
            }
        }
    }
}
