// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.ContainerInstance.Samples
{
    public partial class Sample_ContainerGroupProfileRevisionResource
    {
        // ContainerGroupProfileGetByRevisionNumber
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ContainerGroupProfileGetByRevisionNumber()
        {
            // Generated from example definition: specification/containerinstance/resource-manager/Microsoft.ContainerInstance/preview/2024-05-01-preview/examples/ContainerGroupProfileGetByRevisionNumber.json
            // this example is just showing the usage of "ContainerGroupProfile_GetByRevisionNumber" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerGroupProfileRevisionResource created on azure
            // for more information of creating ContainerGroupProfileRevisionResource, please refer to the document of ContainerGroupProfileRevisionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "demo";
            string containerGroupProfileName = "demo1";
            string revisionNumber = "1";
            ResourceIdentifier containerGroupProfileRevisionResourceId = ContainerGroupProfileRevisionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, containerGroupProfileName, revisionNumber);
            ContainerGroupProfileRevisionResource containerGroupProfileRevision = client.GetContainerGroupProfileRevisionResource(containerGroupProfileRevisionResourceId);

            // invoke the operation
            ContainerGroupProfileRevisionResource result = await containerGroupProfileRevision.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerGroupProfileData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
