// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.ContainerInstance.Samples
{
    public partial class Sample_ContainerGroupProfileRevisionCollection
    {
        // ContainerGroupProfileListAllRevisions
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ContainerGroupProfileListAllRevisions()
        {
            // Generated from example definition: specification/containerinstance/resource-manager/Microsoft.ContainerInstance/preview/2024-05-01-preview/examples/ContainerGroupProfileListAllRevisions.json
            // this example is just showing the usage of "ContainerGroupProfile_ListAllRevisions" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerGroupProfileResource created on azure
            // for more information of creating ContainerGroupProfileResource, please refer to the document of ContainerGroupProfileResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "demo";
            string containerGroupProfileName = "demo1";
            ResourceIdentifier containerGroupProfileResourceId = ContainerGroupProfileResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, containerGroupProfileName);
            ContainerGroupProfileResource containerGroupProfile = client.GetContainerGroupProfileResource(containerGroupProfileResourceId);

            // get the collection of this ContainerGroupProfileRevisionResource
            ContainerGroupProfileRevisionCollection collection = containerGroupProfile.GetContainerGroupProfileRevisions();

            // invoke the operation and iterate over the result
            await foreach (ContainerGroupProfileRevisionResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ContainerGroupProfileData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ContainerGroupProfileGetByRevisionNumber
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ContainerGroupProfileGetByRevisionNumber()
        {
            // Generated from example definition: specification/containerinstance/resource-manager/Microsoft.ContainerInstance/preview/2024-05-01-preview/examples/ContainerGroupProfileGetByRevisionNumber.json
            // this example is just showing the usage of "ContainerGroupProfile_GetByRevisionNumber" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerGroupProfileResource created on azure
            // for more information of creating ContainerGroupProfileResource, please refer to the document of ContainerGroupProfileResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "demo";
            string containerGroupProfileName = "demo1";
            ResourceIdentifier containerGroupProfileResourceId = ContainerGroupProfileResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, containerGroupProfileName);
            ContainerGroupProfileResource containerGroupProfile = client.GetContainerGroupProfileResource(containerGroupProfileResourceId);

            // get the collection of this ContainerGroupProfileRevisionResource
            ContainerGroupProfileRevisionCollection collection = containerGroupProfile.GetContainerGroupProfileRevisions();

            // invoke the operation
            string revisionNumber = "1";
            ContainerGroupProfileRevisionResource result = await collection.GetAsync(revisionNumber);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerGroupProfileData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ContainerGroupProfileGetByRevisionNumber
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_ContainerGroupProfileGetByRevisionNumber()
        {
            // Generated from example definition: specification/containerinstance/resource-manager/Microsoft.ContainerInstance/preview/2024-05-01-preview/examples/ContainerGroupProfileGetByRevisionNumber.json
            // this example is just showing the usage of "ContainerGroupProfile_GetByRevisionNumber" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerGroupProfileResource created on azure
            // for more information of creating ContainerGroupProfileResource, please refer to the document of ContainerGroupProfileResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "demo";
            string containerGroupProfileName = "demo1";
            ResourceIdentifier containerGroupProfileResourceId = ContainerGroupProfileResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, containerGroupProfileName);
            ContainerGroupProfileResource containerGroupProfile = client.GetContainerGroupProfileResource(containerGroupProfileResourceId);

            // get the collection of this ContainerGroupProfileRevisionResource
            ContainerGroupProfileRevisionCollection collection = containerGroupProfile.GetContainerGroupProfileRevisions();

            // invoke the operation
            string revisionNumber = "1";
            bool result = await collection.ExistsAsync(revisionNumber);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ContainerGroupProfileGetByRevisionNumber
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_ContainerGroupProfileGetByRevisionNumber()
        {
            // Generated from example definition: specification/containerinstance/resource-manager/Microsoft.ContainerInstance/preview/2024-05-01-preview/examples/ContainerGroupProfileGetByRevisionNumber.json
            // this example is just showing the usage of "ContainerGroupProfile_GetByRevisionNumber" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerGroupProfileResource created on azure
            // for more information of creating ContainerGroupProfileResource, please refer to the document of ContainerGroupProfileResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "demo";
            string containerGroupProfileName = "demo1";
            ResourceIdentifier containerGroupProfileResourceId = ContainerGroupProfileResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, containerGroupProfileName);
            ContainerGroupProfileResource containerGroupProfile = client.GetContainerGroupProfileResource(containerGroupProfileResourceId);

            // get the collection of this ContainerGroupProfileRevisionResource
            ContainerGroupProfileRevisionCollection collection = containerGroupProfile.GetContainerGroupProfileRevisions();

            // invoke the operation
            string revisionNumber = "1";
            NullableResponse<ContainerGroupProfileRevisionResource> response = await collection.GetIfExistsAsync(revisionNumber);
            ContainerGroupProfileRevisionResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ContainerGroupProfileData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
