// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Container App to be a dev service. </summary>
    internal partial class Service
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="Service"/>. </summary>
        /// <param name="serviceType"> Dev ContainerApp service type. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="serviceType"/> is null. </exception>
        public Service(string serviceType)
        {
            Argument.AssertNotNull(serviceType, nameof(serviceType));

            ServiceType = serviceType;
        }

        /// <summary> Initializes a new instance of <see cref="Service"/>. </summary>
        /// <param name="serviceType"> Dev ContainerApp service type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal Service(string serviceType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ServiceType = serviceType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="Service"/> for deserialization. </summary>
        internal Service()
        {
        }

        /// <summary> Dev ContainerApp service type. </summary>
        [WirePath("type")]
        public string ServiceType { get; set; }
    }
}
