// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppContainers.Models
{
    internal partial class ManagedEnvironmentPropertiesPeerAuthentication : IUtf8JsonSerializable, IJsonModel<ManagedEnvironmentPropertiesPeerAuthentication>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ManagedEnvironmentPropertiesPeerAuthentication>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ManagedEnvironmentPropertiesPeerAuthentication>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManagedEnvironmentPropertiesPeerAuthentication>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ManagedEnvironmentPropertiesPeerAuthentication)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Mtls))
            {
                writer.WritePropertyName("mtls"u8);
                writer.WriteObjectValue(Mtls, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ManagedEnvironmentPropertiesPeerAuthentication IJsonModel<ManagedEnvironmentPropertiesPeerAuthentication>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManagedEnvironmentPropertiesPeerAuthentication>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ManagedEnvironmentPropertiesPeerAuthentication)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeManagedEnvironmentPropertiesPeerAuthentication(document.RootElement, options);
        }

        internal static ManagedEnvironmentPropertiesPeerAuthentication DeserializeManagedEnvironmentPropertiesPeerAuthentication(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            Mtls mtls = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("mtls"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    mtls = Mtls.DeserializeMtls(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ManagedEnvironmentPropertiesPeerAuthentication(mtls, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("IsMtlsEnabled", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  mtls: ");
                builder.AppendLine("{");
                builder.Append("    enabled: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(Mtls))
                {
                    builder.Append("  mtls: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Mtls, options, 2, false, "  mtls: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ManagedEnvironmentPropertiesPeerAuthentication>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManagedEnvironmentPropertiesPeerAuthentication>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ManagedEnvironmentPropertiesPeerAuthentication)} does not support writing '{options.Format}' format.");
            }
        }

        ManagedEnvironmentPropertiesPeerAuthentication IPersistableModel<ManagedEnvironmentPropertiesPeerAuthentication>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManagedEnvironmentPropertiesPeerAuthentication>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeManagedEnvironmentPropertiesPeerAuthentication(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ManagedEnvironmentPropertiesPeerAuthentication)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ManagedEnvironmentPropertiesPeerAuthentication>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
