// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Selected type of domain control validation for managed certificates. </summary>
    public readonly partial struct ManagedCertificateDomainControlValidation : IEquatable<ManagedCertificateDomainControlValidation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedCertificateDomainControlValidation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedCertificateDomainControlValidation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CnameValue = "CNAME";
        private const string HttpValue = "HTTP";
        private const string TXTValue = "TXT";

        /// <summary> CNAME. </summary>
        public static ManagedCertificateDomainControlValidation Cname { get; } = new ManagedCertificateDomainControlValidation(CnameValue);
        /// <summary> HTTP. </summary>
        public static ManagedCertificateDomainControlValidation Http { get; } = new ManagedCertificateDomainControlValidation(HttpValue);
        /// <summary> TXT. </summary>
        public static ManagedCertificateDomainControlValidation TXT { get; } = new ManagedCertificateDomainControlValidation(TXTValue);
        /// <summary> Determines if two <see cref="ManagedCertificateDomainControlValidation"/> values are the same. </summary>
        public static bool operator ==(ManagedCertificateDomainControlValidation left, ManagedCertificateDomainControlValidation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedCertificateDomainControlValidation"/> values are not the same. </summary>
        public static bool operator !=(ManagedCertificateDomainControlValidation left, ManagedCertificateDomainControlValidation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedCertificateDomainControlValidation"/>. </summary>
        public static implicit operator ManagedCertificateDomainControlValidation(string value) => new ManagedCertificateDomainControlValidation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedCertificateDomainControlValidation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedCertificateDomainControlValidation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
