// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Current running State of the job. </summary>
    public readonly partial struct JobExecutionRunningState : IEquatable<JobExecutionRunningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="JobExecutionRunningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public JobExecutionRunningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RunningValue = "Running";
        private const string ProcessingValue = "Processing";
        private const string StoppedValue = "Stopped";
        private const string DegradedValue = "Degraded";
        private const string FailedValue = "Failed";
        private const string UnknownValue = "Unknown";
        private const string SucceededValue = "Succeeded";

        /// <summary> Running. </summary>
        public static JobExecutionRunningState Running { get; } = new JobExecutionRunningState(RunningValue);
        /// <summary> Processing. </summary>
        public static JobExecutionRunningState Processing { get; } = new JobExecutionRunningState(ProcessingValue);
        /// <summary> Stopped. </summary>
        public static JobExecutionRunningState Stopped { get; } = new JobExecutionRunningState(StoppedValue);
        /// <summary> Degraded. </summary>
        public static JobExecutionRunningState Degraded { get; } = new JobExecutionRunningState(DegradedValue);
        /// <summary> Failed. </summary>
        public static JobExecutionRunningState Failed { get; } = new JobExecutionRunningState(FailedValue);
        /// <summary> Unknown. </summary>
        public static JobExecutionRunningState Unknown { get; } = new JobExecutionRunningState(UnknownValue);
        /// <summary> Succeeded. </summary>
        public static JobExecutionRunningState Succeeded { get; } = new JobExecutionRunningState(SucceededValue);
        /// <summary> Determines if two <see cref="JobExecutionRunningState"/> values are the same. </summary>
        public static bool operator ==(JobExecutionRunningState left, JobExecutionRunningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="JobExecutionRunningState"/> values are not the same. </summary>
        public static bool operator !=(JobExecutionRunningState left, JobExecutionRunningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="JobExecutionRunningState"/>. </summary>
        public static implicit operator JobExecutionRunningState(string value) => new JobExecutionRunningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is JobExecutionRunningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(JobExecutionRunningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
