// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Cron formatted repeating trigger schedule ("* * * * *") for cronjobs. Properties completions and parallelism would be set to 1 by default. </summary>
    public partial class JobConfigurationScheduleTriggerConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="JobConfigurationScheduleTriggerConfig"/>. </summary>
        /// <param name="cronExpression"> Cron formatted repeating schedule ("* * * * *") of a Cron Job. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="cronExpression"/> is null. </exception>
        public JobConfigurationScheduleTriggerConfig(string cronExpression)
        {
            Argument.AssertNotNull(cronExpression, nameof(cronExpression));

            CronExpression = cronExpression;
        }

        /// <summary> Initializes a new instance of <see cref="JobConfigurationScheduleTriggerConfig"/>. </summary>
        /// <param name="replicaCompletionCount"> Minimum number of successful replica completions before overall job completion. </param>
        /// <param name="cronExpression"> Cron formatted repeating schedule ("* * * * *") of a Cron Job. </param>
        /// <param name="parallelism"> Number of parallel replicas of a job that can run at a given time. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal JobConfigurationScheduleTriggerConfig(int? replicaCompletionCount, string cronExpression, int? parallelism, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ReplicaCompletionCount = replicaCompletionCount;
            CronExpression = cronExpression;
            Parallelism = parallelism;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="JobConfigurationScheduleTriggerConfig"/> for deserialization. </summary>
        internal JobConfigurationScheduleTriggerConfig()
        {
        }

        /// <summary> Minimum number of successful replica completions before overall job completion. </summary>
        [WirePath("replicaCompletionCount")]
        public int? ReplicaCompletionCount { get; set; }
        /// <summary> Cron formatted repeating schedule ("* * * * *") of a Cron Job. </summary>
        [WirePath("cronExpression")]
        public string CronExpression { get; set; }
        /// <summary> Number of parallel replicas of a job that can run at a given time. </summary>
        [WirePath("parallelism")]
        public int? Parallelism { get; set; }
    }
}
