// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppContainers.Models
{
    public partial class IngressPortMapping : IUtf8JsonSerializable, IJsonModel<IngressPortMapping>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<IngressPortMapping>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<IngressPortMapping>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IngressPortMapping>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IngressPortMapping)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("external"u8);
            writer.WriteBooleanValue(External);
            writer.WritePropertyName("targetPort"u8);
            writer.WriteNumberValue(TargetPort);
            if (Optional.IsDefined(ExposedPort))
            {
                writer.WritePropertyName("exposedPort"u8);
                writer.WriteNumberValue(ExposedPort.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        IngressPortMapping IJsonModel<IngressPortMapping>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IngressPortMapping>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IngressPortMapping)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeIngressPortMapping(document.RootElement, options);
        }

        internal static IngressPortMapping DeserializeIngressPortMapping(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool external = default;
            int targetPort = default;
            int? exposedPort = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("external"u8))
                {
                    external = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("targetPort"u8))
                {
                    targetPort = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("exposedPort"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    exposedPort = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new IngressPortMapping(external, targetPort, exposedPort, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(External), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  external: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  external: ");
                var boolValue = External == true ? "true" : "false";
                builder.AppendLine($"{boolValue}");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TargetPort), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  targetPort: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  targetPort: ");
                builder.AppendLine($"{TargetPort}");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ExposedPort), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  exposedPort: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ExposedPort))
                {
                    builder.Append("  exposedPort: ");
                    builder.AppendLine($"{ExposedPort.Value}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<IngressPortMapping>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IngressPortMapping>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(IngressPortMapping)} does not support writing '{options.Format}' format.");
            }
        }

        IngressPortMapping IPersistableModel<IngressPortMapping>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IngressPortMapping>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeIngressPortMapping(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(IngressPortMapping)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<IngressPortMapping>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
