// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Trigger configuration of an event driven job. </summary>
    public partial class EventTriggerConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EventTriggerConfiguration"/>. </summary>
        public EventTriggerConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EventTriggerConfiguration"/>. </summary>
        /// <param name="replicaCompletionCount"> Minimum number of successful replica completions before overall job completion. </param>
        /// <param name="parallelism"> Number of parallel replicas of a job that can run at a given time. </param>
        /// <param name="scale"> Scaling configurations for event driven jobs. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EventTriggerConfiguration(int? replicaCompletionCount, int? parallelism, ContainerAppJobScale scale, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ReplicaCompletionCount = replicaCompletionCount;
            Parallelism = parallelism;
            Scale = scale;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Minimum number of successful replica completions before overall job completion. </summary>
        [WirePath("replicaCompletionCount")]
        public int? ReplicaCompletionCount { get; set; }
        /// <summary> Number of parallel replicas of a job that can run at a given time. </summary>
        [WirePath("parallelism")]
        public int? Parallelism { get; set; }
        /// <summary> Scaling configurations for event driven jobs. </summary>
        [WirePath("scale")]
        public ContainerAppJobScale Scale { get; set; }
    }
}
